/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.state;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.infumia.frame.Lazy;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.element.pagination.ElementPagination;
import net.infumia.frame.element.pagination.ElementPaginationBuilder;
import net.infumia.frame.element.pagination.ElementPaginationBuilderImpl;
import net.infumia.frame.element.pagination.ElementPaginationBuilderRich;
import net.infumia.frame.element.pagination.SourceProvider;
import net.infumia.frame.state.State;
import net.infumia.frame.state.StateFactory;
import net.infumia.frame.state.StateImpl;
import net.infumia.frame.state.StateInitial;
import net.infumia.frame.state.StateInitialImpl;
import net.infumia.frame.state.StateMutable;
import net.infumia.frame.state.StateMutableImpl;
import net.infumia.frame.state.StatePaginationImpl;
import net.infumia.frame.state.StateRegistry;
import net.infumia.frame.state.StateRich;
import net.infumia.frame.state.pagination.PaginationElementConfigurer;
import net.infumia.frame.state.pagination.StatePagination;
import net.infumia.frame.state.value.StateValueComputed;
import net.infumia.frame.state.value.StateValueImmutable;
import net.infumia.frame.state.value.StateValueInitial;
import net.infumia.frame.state.value.StateValueMutable;
import net.infumia.frame.typedkey.TypedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateFactoryImpl
implements StateFactory {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final StateRegistry registry;

    public StateFactoryImpl(@NotNull StateRegistry registry) {
        this.registry = registry;
    }

    @NotNull
    public <T> StateInitial<T> createInitialState(@NotNull TypedKey<T> stateKey) {
        return this.registered(new StateInitialImpl(StateFactoryImpl.nextStateId(), (host, __) -> new StateValueInitial((ContextBase)host, stateKey.key()), stateKey.key()));
    }

    @NotNull
    public <T> State<T> createState(@NotNull T initialValue) {
        return this.registered(new StateImpl(StateFactoryImpl.nextStateId(), (host, __) -> new StateValueImmutable<Object>(initialValue)));
    }

    @NotNull
    public <T> StateMutable<T> createMutableState(@Nullable T initialValue) {
        return this.registered(new StateMutableImpl(StateFactoryImpl.nextStateId(), (host, __) -> new StateValueMutable<Object>(initialValue)));
    }

    @NotNull
    public <T> State<T> createComputedState(@NotNull Function<ContextBase, T> computation) {
        return this.registered(new StateImpl(StateFactoryImpl.nextStateId(), (host, __) -> new StateValueComputed<Object>(() -> computation.apply((ContextBase)host))));
    }

    @NotNull
    public <T> State<T> createComputedState(@NotNull Supplier<T> computation) {
        return this.registered(new StateImpl(StateFactoryImpl.nextStateId(), (host, __) -> new StateValueComputed(computation)));
    }

    @NotNull
    public <T> State<T> createLazyState(@NotNull Function<ContextBase, T> computation) {
        return this.registered(new StateImpl(StateFactoryImpl.nextStateId(), (host, __) -> new StateValueComputed(Lazy.of(() -> computation.apply((ContextBase)host)))));
    }

    @NotNull
    public <T> State<T> createLazyState(@NotNull Supplier<T> computation) {
        return this.registered(new StateImpl(StateFactoryImpl.nextStateId(), (host, __) -> new StateValueComputed(Lazy.of((Supplier)computation))));
    }

    @NotNull
    public <T> StatePagination createPaginationState(@NotNull List<T> source, @NotNull PaginationElementConfigurer<T> configurer) {
        return this.buildPaginationState(source).elementConfigurer(configurer).buildPagination();
    }

    @NotNull
    public <T> StatePagination createComputedPaginationState(@NotNull Supplier<List<T>> source, @NotNull PaginationElementConfigurer<T> configurer) {
        return this.buildComputedPaginationState(source).elementConfigurer(configurer).buildPagination();
    }

    @NotNull
    public <T> StatePagination createComputedPaginationState(@NotNull Function<ContextBase, List<T>> source, @NotNull PaginationElementConfigurer<T> configurer) {
        return this.buildComputedPaginationState(source).elementConfigurer(configurer).buildPagination();
    }

    @NotNull
    public <T> StatePagination createComputedAsyncPaginationState(@NotNull Supplier<CompletableFuture<List<T>>> source, @NotNull PaginationElementConfigurer<T> configurer) {
        return this.buildComputedAsyncPaginationState(source).elementConfigurer(configurer).buildPagination();
    }

    @NotNull
    public <T> StatePagination createComputedAsyncPaginationState(@NotNull Function<ContextBase, CompletableFuture<List<T>>> source, @NotNull PaginationElementConfigurer<T> configurer) {
        return this.buildComputedAsyncPaginationState(source).elementConfigurer(configurer).buildPagination();
    }

    @NotNull
    public <T> StatePagination createLazyPaginationState(@NotNull Supplier<List<T>> source, @NotNull PaginationElementConfigurer<T> configurer) {
        return this.buildLazyPaginationState(source).elementConfigurer(configurer).buildPagination();
    }

    @NotNull
    public <T> StatePagination createLazyPaginationState(@NotNull Function<ContextBase, List<T>> source, @NotNull PaginationElementConfigurer<T> configurer) {
        return this.buildLazyPaginationState(source).elementConfigurer(configurer).buildPagination();
    }

    @NotNull
    public <T> StatePagination createLazyAsyncPaginationState(@NotNull Supplier<CompletableFuture<List<T>>> source, @NotNull PaginationElementConfigurer<T> configurer) {
        return this.buildLazyAsyncPaginationState(source).elementConfigurer(configurer).buildPagination();
    }

    @NotNull
    public <T> StatePagination createLazyAsyncPaginationState(@NotNull Function<ContextBase, CompletableFuture<List<T>>> source, @NotNull PaginationElementConfigurer<T> configurer) {
        return this.buildLazyAsyncPaginationState(source).elementConfigurer(configurer).buildPagination();
    }

    @NotNull
    public <T> ElementPaginationBuilder<T> buildPaginationState(@NotNull List<T> source) {
        return new ElementPaginationBuilderImpl<T>(new SourceProvider.Immutable<T>(source), this::createPaginationState);
    }

    @NotNull
    public <T> ElementPaginationBuilder<T> buildComputedPaginationState(@NotNull Supplier<List<T>> source) {
        return new ElementPaginationBuilderImpl(new SourceProvider.Computed(() -> CompletableFuture.completedFuture(source.get()), true, false, false), this::createPaginationState);
    }

    @NotNull
    public <T> ElementPaginationBuilder<T> buildComputedPaginationState(@NotNull Function<ContextBase, List<T>> source) {
        return new ElementPaginationBuilderImpl(new SourceProvider.Computed(context -> CompletableFuture.completedFuture(source.apply((ContextBase)context)), true, false, false), this::createPaginationState);
    }

    @NotNull
    public <T> ElementPaginationBuilder<T> buildComputedAsyncPaginationState(@NotNull Supplier<CompletableFuture<List<T>>> source) {
        return new ElementPaginationBuilderImpl<T>(new SourceProvider.Computed<T>(source, true, false, true), this::createPaginationState);
    }

    @NotNull
    public <T> ElementPaginationBuilder<T> buildComputedAsyncPaginationState(@NotNull Function<ContextBase, CompletableFuture<List<T>>> source) {
        return new ElementPaginationBuilderImpl<T>(new SourceProvider.Computed<T>(source, true, false, true), this::createPaginationState);
    }

    @NotNull
    public <T> ElementPaginationBuilder<T> buildLazyPaginationState(@NotNull Supplier<List<T>> source) {
        return new ElementPaginationBuilderImpl(new SourceProvider.Computed(() -> CompletableFuture.completedFuture(source.get()), false, true, false), this::createPaginationState);
    }

    @NotNull
    public <T> ElementPaginationBuilder<T> buildLazyPaginationState(@NotNull Function<ContextBase, List<T>> source) {
        return new ElementPaginationBuilderImpl(new SourceProvider.Computed(context -> CompletableFuture.completedFuture(source.apply((ContextBase)context)), false, true, false), this::createPaginationState);
    }

    @NotNull
    public <T> ElementPaginationBuilder<T> buildLazyAsyncPaginationState(@NotNull Supplier<CompletableFuture<List<T>>> source) {
        return new ElementPaginationBuilderImpl<T>(new SourceProvider.Computed<T>(source, false, true, true), this::createPaginationState);
    }

    @NotNull
    public <T> ElementPaginationBuilder<T> buildLazyAsyncPaginationState(@NotNull Function<ContextBase, CompletableFuture<List<T>>> source) {
        return new ElementPaginationBuilderImpl<T>(new SourceProvider.Computed<T>(source, false, true, true), this::createPaginationState);
    }

    @NotNull
    private <T> StatePagination createPaginationState(@NotNull ElementPaginationBuilder<T> builder) {
        return this.registered(new StatePaginationImpl(StateFactoryImpl.nextStateId(), (host, state) -> {
            ElementPaginationBuilderRich b = (ElementPaginationBuilderRich)builder;
            b.associated((State<ElementPagination>)state);
            return new StateValueImmutable<ElementPagination>((ElementPagination)b.build((ContextBase)host));
        }));
    }

    @NotNull
    private <T, S extends StateRich<T>> S registered(@NotNull S state) {
        this.registry.register(state);
        return state;
    }

    private static long nextStateId() {
        return COUNTER.getAndIncrement();
    }
}

