/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.service.view;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.infumia.frame.InvTypeRich;
import net.infumia.frame.InvTypes;
import net.infumia.frame.Preconditions;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.pipeline.PipelineService;
import net.infumia.frame.pipeline.context.PipelineContextView;
import net.infumia.frame.type.InvType;
import net.infumia.frame.view.InventoryHolderFrame;
import net.infumia.frame.view.ViewContainer;
import net.infumia.frame.view.ViewContainerImpl;
import net.infumia.frame.view.config.ViewConfig;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public final class ServiceCreateContainer
implements PipelineService<PipelineContextView.CreateContainer, ViewContainer> {
    private static final Collection<InvTypeRich> EXTENDABLE = Arrays.stream(InvType.VALUES).map(InvTypes::fromType).filter(InvTypeRich::extendable).collect(Collectors.toSet());
    public static final PipelineService<PipelineContextView.CreateContainer, ViewContainer> INSTANCE = new ServiceCreateContainer();
    public static final String KEY = "create";

    @NotNull
    public CompletableFuture<ViewContainer> handle(@NotNull PipelineContextView.CreateContainer ctx) {
        ContextBase context = ctx.context();
        Object instance = context.view().instance();
        ViewConfig config = ctx.config();
        InvType type = config.type();
        InvTypeRich typeRich = InvTypes.fromType(type);
        InventoryType inventoryType = typeRich.toInventoryType();
        Preconditions.argumentNotNull((Object)inventoryType, (String)"%s view type is not supported!", (Object[])new Object[]{type});
        int normalized = typeRich.normalize(config.size());
        Preconditions.argument((normalized == 0 || typeRich.extendable() ? 1 : 0) != 0, (String)"Only '%s' type(s) can have a custom size, '%s' always have a size of %d. Remove the part that specifies the size of the container on %s or just set the type explicitly.", (Object[])new Object[]{EXTENDABLE.stream().map(InvTypeRich::type).collect(Collectors.toSet()), type, typeRich.maxSize(), instance});
        InventoryHolderFrame holder = new InventoryHolderFrame();
        Inventory inventory = context.frame().inventoryFactory().create((InventoryHolder)holder, inventoryType, normalized, config.title());
        holder.inventory(inventory);
        return CompletableFuture.completedFuture(new ViewContainerImpl(holder, typeRich));
    }

    @NotNull
    public String key() {
        return KEY;
    }

    private ServiceCreateContainer() {
    }
}

