/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.executor;

import java.util.concurrent.CompletableFuture;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.pipeline.context.PipelineContextState;
import net.infumia.frame.pipeline.context.PipelineContextStates;
import net.infumia.frame.pipeline.executor.PipelinesState;
import net.infumia.frame.pipeline.holder.PipelineHolderState;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.state.State;
import net.infumia.frame.state.value.StateValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PipelinesStateImpl
implements PipelinesState {
    private final PipelineHolderState pipelines = PipelineHolderState.BASE.cloned();
    private final ContextBase context;

    public PipelinesStateImpl(@NotNull ContextBase context) {
        this.context = context;
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeAccess(@NotNull State<?> state, @NotNull StateValue<?> value) {
        return this.pipelines.access().completeWith((Object)new PipelineContextStates.Access(this.context.frame(), state, value));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeUpdate(@NotNull State<?> state, @Nullable Object oldValue, @NotNull StateValue<?> value) {
        return this.pipelines.update().completeWith((Object)new PipelineContextStates.Update(this.context.frame(), state, oldValue, value));
    }

    public void applyAccess(@NotNull Implementation<PipelineContextState.Access, ConsumerService.State> implementation) {
        this.pipelines.access().apply(implementation);
    }

    public void applyUpdate(@NotNull Implementation<PipelineContextState.Update, ConsumerService.State> implementation) {
        this.pipelines.update().apply(implementation);
    }
}

