/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element.pagination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.infumia.frame.Preconditions;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementEventHandler;
import net.infumia.frame.element.ElementImpl;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.element.item.ElementItem;
import net.infumia.frame.element.item.ElementItemBuilder;
import net.infumia.frame.element.item.ElementItemBuilderImpl;
import net.infumia.frame.element.pagination.ElementEventHandlerPagination;
import net.infumia.frame.element.pagination.ElementPagination;
import net.infumia.frame.element.pagination.ElementPaginationBuilderImpl;
import net.infumia.frame.element.pagination.ElementPaginationRich;
import net.infumia.frame.element.pagination.SourceProvider;
import net.infumia.frame.pipeline.executor.PipelinesElement;
import net.infumia.frame.pipeline.executor.PipelinesElementImpl;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.slot.LayoutSlot;
import net.infumia.frame.state.State;
import net.infumia.frame.state.pagination.PaginationElementConfigurer;
import net.infumia.frame.view.ViewContainer;
import org.jetbrains.annotations.NotNull;

public final class ElementPaginationImpl<T>
extends ElementImpl
implements ElementPaginationRich {
    private final PipelinesElement pipelines = new PipelinesElementImpl(this);
    private final ElementEventHandler eventHandler = ElementEventHandlerPagination.INSTANCE;
    private LayoutSlot currentLayoutSlot;
    private final SourceProvider<T> sourceProvider;
    private final char layout;
    private final BiConsumer<ContextBase, ElementPagination> onPageSwitch;
    private final PaginationElementConfigurer<T> elementConfigurer;
    private final State<ElementPagination> associated;
    private final Function<ContextBase, CompletableFuture<List<T>>> sourceFactory;
    private final Function<List<T>, List<T>> pageCalculation;
    private final Executor continuationExecutor;
    private List<Element> elements = new ArrayList<Element>();
    private int currentPageIndex;
    private boolean pageWasChanged;
    private boolean initialized = false;
    private int pageCount;
    private List<T> currentSource;
    private boolean loading;
    private int pageSize = -1;

    ElementPaginationImpl(@NotNull ElementPaginationBuilderImpl<T> builder, @NotNull ContextBase parent) {
        super(builder, parent);
        this.associated = (State)Preconditions.argumentNotNull(builder.associated, (String)"Associated state cannot be null for ElementPagination!", (Object[])new Object[0]);
        this.elementConfigurer = (PaginationElementConfigurer)Preconditions.argumentNotNull(builder.elementConfigurer, (String)"Element configurer cannot be null for ElementPagination!", (Object[])new Object[0]);
        this.sourceProvider = builder.sourceProvider;
        this.layout = builder.layout;
        this.onPageSwitch = builder.onPageSwitch;
        if (this.sourceProvider instanceof SourceProvider.Immutable) {
            this.currentSource = (List)((CompletableFuture)this.sourceProvider.apply(this.parent)).join();
            this.sourceFactory = null;
        } else {
            this.sourceFactory = this.sourceProvider;
        }
        this.continuationExecutor = this.sourceProvider.async() ? parent.frame().taskFactory().asExecutor() : Runnable::run;
        this.pageCalculation = result -> {
            this.loading = false;
            this.currentSource = result;
            this.pageCount = this.calculatePagesCount((List<T>)result);
            int lastOrCurrentPage = Math.min(this.currentPageIndex, this.lastPageIndex());
            if (lastOrCurrentPage != this.currentPageIndex) {
                this.switchTo(lastOrCurrentPage);
            }
            return ElementPaginationImpl.splitSourceForPage(this.currentPageIndex, this.pageSize(), this.pageCount, result);
        };
    }

    @Override
    @NotNull
    public State<ElementPagination> associated() {
        return this.associated;
    }

    @Override
    public boolean pageWasChanged() {
        return this.pageWasChanged;
    }

    @Override
    public void pageWasChanged(boolean pageWasChanged) {
        this.pageWasChanged = pageWasChanged;
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public void initialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public void updatePageSize(@NotNull ContextRender context) {
        String[] layout = context.config().layout();
        this.pageSize = layout == null ? context.container().size() : this.layoutSlotFor(context).slots().length;
    }

    @Override
    @NotNull
    public CompletableFuture<?> loadCurrentPage(@NotNull ContextRender context, boolean forced) {
        return this.loadSourceForTheCurrentPage((ContextBase)context, forced).thenAccept(pageContents -> {
            if (pageContents.isEmpty()) {
                return;
            }
            if (context.layouts().isEmpty()) {
                this.addComponentsForUnconstrainedPagination(context, (List<T>)pageContents);
            } else {
                this.addComponentsForLayeredPagination(context, (List<T>)pageContents);
            }
        });
    }

    @Override
    @NotNull
    public Collection<Element> modifiableElements() {
        return this.elements;
    }

    @Override
    public void clearElements() {
        this.elements = new ArrayList<Element>();
    }

    public int currentPageIndex() {
        return this.currentPageIndex;
    }

    public int nextPageIndex() {
        return Math.max(0, Math.min(this.pageCount, this.currentPageIndex + 1));
    }

    public int previousPageIndex() {
        return Math.max(0, Math.min(this.pageCount, this.currentPageIndex - 1));
    }

    public int lastPageIndex() {
        return Math.max(0, this.pageCount - 1);
    }

    public boolean isFirstPage() {
        return this.currentPageIndex == 0;
    }

    public boolean isLastPage() {
        return !this.canAdvance();
    }

    public int elementCount() {
        return this.currentSource == null ? 0 : this.currentSource.size();
    }

    public int pageCount() {
        return this.pageCount;
    }

    public boolean hasPage(int pageIndex) {
        if (this.sourceProvider.computed()) {
            return true;
        }
        if (pageIndex < 0) {
            return false;
        }
        return pageIndex < this.pageCount;
    }

    public void switchTo(int pageIndex) {
        Preconditions.state((boolean)this.hasPage(pageIndex), (String)"Page index not found (%d > %d)", (Object[])new Object[]{pageIndex, this.pageCount});
        if (this.loading) {
            return;
        }
        this.currentPageIndex = Math.max(0, pageIndex);
        this.pageWasChanged = true;
        ContextRender host = (ContextRender)this.parent;
        if (this.onPageSwitch != null) {
            this.onPageSwitch.accept((ContextBase)host, this);
        }
        this.parent.frame().loggedFuture(this.update(), "An error occurred while updating the pagination '%s'.", new Object[]{this});
    }

    public void advance() {
        if (this.canAdvance()) {
            this.switchTo(this.nextPageIndex());
        }
    }

    public boolean canAdvance() {
        return this.hasPage(this.nextPageIndex());
    }

    public void back() {
        if (this.canBack()) {
            this.switchTo(this.previousPageIndex());
        }
    }

    public boolean canBack() {
        return this.hasPage(this.previousPageIndex());
    }

    @Override
    @NotNull
    public ElementEventHandler eventHandler() {
        return this.eventHandler;
    }

    @Override
    public void visible(boolean visible) {
        super.visible(visible);
        for (Element child : this.elements) {
            ((ElementRich)child).visible(visible);
        }
    }

    @Override
    public boolean containedWithin(int position) {
        if (this.currentLayoutSlot != null) {
            return Arrays.stream(this.currentLayoutSlot.slots()).anyMatch(slot -> slot == position);
        }
        return this.elements.stream().anyMatch(element -> ((ElementRich)element).containedWithin(position));
    }

    @Override
    public boolean intersects(@NotNull Element element) {
        for (Element child : this.elements) {
            ElementRich e = (ElementRich)child;
            if (e.intersects(element)) {
                return true;
            }
            if (!(e instanceof ElementItem)) continue;
            int slot = ((ElementItem)e).slot();
            if (this.currentLayoutSlot != null) {
                return Arrays.stream(this.currentLayoutSlot.slots()).anyMatch(s -> s == slot);
            }
            return e.containedWithin(slot);
        }
        return false;
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> update() {
        Preconditions.state((boolean)(this.parent instanceof ContextRender), (String)"You cannot update the element '%s' when the parent is not a ContextRender!", (Object[])new Object[]{this});
        return this.pipelines.executeUpdate((ContextRender)this.parent, false);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> forceUpdate() {
        Preconditions.state((boolean)(this.parent instanceof ContextRender), (String)"You cannot update the element '%s' when the parent is not a ContextRender!", (Object[])new Object[]{this});
        return this.pipelines.executeUpdate((ContextRender)this.parent, true);
    }

    @Override
    @NotNull
    public PipelinesElement pipelines() {
        return this.pipelines;
    }

    @NotNull
    public List<Element> elements() {
        return Collections.unmodifiableList(this.elements);
    }

    private void addComponentsForUnconstrainedPagination(@NotNull ContextRender context, @NotNull List<T> contents) {
        ViewContainer container = context.container();
        int lastSlot = Math.min(container.lastSlot() + 1, contents.size());
        int index = 0;
        for (int slot = container.firstSlot(); slot < lastSlot; ++slot) {
            T value = contents.get(slot);
            ElementItemBuilderImpl builder = new ElementItemBuilderImpl();
            builder.root(this);
            builder.slot(slot);
            this.elementConfigurer.configure((ContextBase)context, (ElementItemBuilder)builder, index++, slot, value);
            this.elements.add(builder.build((ContextBase)context));
        }
    }

    private void addComponentsForLayeredPagination(@NotNull ContextRender context, @NotNull List<T> contents) {
        LayoutSlot layoutSlot = this.layoutSlotFor(context);
        int elementCount = contents.size();
        int index = 0;
        for (int slot : layoutSlot.slots()) {
            if (index >= elementCount) break;
            T value = contents.get(index);
            ElementItemBuilderImpl builder = new ElementItemBuilderImpl();
            builder.root(this);
            builder.slot(slot);
            this.elementConfigurer.configure((ContextBase)context, (ElementItemBuilder)builder, index++, slot, value);
            this.elements.add(builder.build((ContextBase)context));
        }
    }

    @NotNull
    private CompletableFuture<List<T>> loadSourceForTheCurrentPage(@NotNull ContextBase context, boolean forced) {
        boolean notComputing;
        boolean isLazy = this.sourceProvider.lazy();
        boolean lazyInitialized = isLazy && this.initialized;
        boolean canReuse = this.sourceProvider.provided() || lazyInitialized;
        boolean bl = notComputing = !this.sourceProvider.computed();
        if (canReuse && notComputing && !forced) {
            List currentSource = (List)Preconditions.stateNotNull(this.currentSource, (String)"Current source cannot be null in this stage", (Object[])new Object[0]);
            if (!isLazy) {
                this.pageCount = this.calculatePagesCount(currentSource);
            }
            return CompletableFuture.completedFuture(ElementPaginationImpl.splitSourceForPage(this.currentPageIndex, this.pageSize(), this.pageCount, currentSource));
        }
        this.loading = true;
        if (this.sourceFactory == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return ((CompletableFuture)this.sourceFactory.apply(context).thenApply(this.pageCalculation)).thenApplyAsync(Function.identity(), this.continuationExecutor);
    }

    private int calculatePagesCount(@NotNull List<T> source) {
        return (int)Math.ceil((double)source.size() / (double)this.pageSize());
    }

    private int pageSize() {
        Preconditions.state((this.pageSize != -1 ? 1 : 0) != 0, (String)"Page size need to be updated before try to get it", (Object[])new Object[0]);
        return this.pageSize;
    }

    @NotNull
    private LayoutSlot layoutSlotFor(@NotNull ContextRender context) {
        LayoutSlot layoutSlot;
        if (this.currentLayoutSlot != null) {
            return this.currentLayoutSlot;
        }
        this.currentLayoutSlot = layoutSlot = context.layouts().stream().filter(slot -> slot.character() == this.layout).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Layout slot target not found: %c", Character.valueOf(this.layout))));
        return this.currentLayoutSlot;
    }

    @NotNull
    private static <T> List<T> splitSourceForPage(int index, int pageSize, int pagesCount, @NotNull List<T> src) {
        if (src.isEmpty()) {
            return Collections.emptyList();
        }
        if (src.size() <= pageSize) {
            return new ArrayList<T>(src);
        }
        if (index < 0 || pagesCount > 0 && index >= pagesCount) {
            throw new IndexOutOfBoundsException(String.format("Page index must be between the range of 0 and %d. Given: %d", pagesCount - 1, index));
        }
        LinkedList<T> contents = new LinkedList<T>();
        int base = index * pageSize;
        int until = base + pageSize;
        if (until > src.size()) {
            until = src.size();
        }
        for (int i = base; i < until; ++i) {
            contents.add(src.get(i));
        }
        return contents;
    }
}

