/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element.pagination;

import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.element.ContextElementClick;
import net.infumia.frame.context.element.ContextElementRender;
import net.infumia.frame.element.ElementBuilderImpl;
import net.infumia.frame.element.item.ElementItemBuilder;
import net.infumia.frame.element.pagination.ElementPagination;
import net.infumia.frame.element.pagination.ElementPaginationBuilder;
import net.infumia.frame.element.pagination.ElementPaginationBuilderRich;
import net.infumia.frame.element.pagination.ElementPaginationImpl;
import net.infumia.frame.element.pagination.SourceProvider;
import net.infumia.frame.state.State;
import net.infumia.frame.state.pagination.PaginationElementConfigurer;
import net.infumia.frame.state.pagination.StatePagination;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ElementPaginationBuilderImpl<T>
extends ElementBuilderImpl
implements ElementPaginationBuilderRich<T> {
    private final Function<ElementPaginationBuilder<T>, StatePagination> stateFactory;
    final SourceProvider<T> sourceProvider;
    char layout = (char)48;
    BiConsumer<ContextBase, ElementPagination> onPageSwitch;
    PaginationElementConfigurer<T> elementConfigurer;
    State<ElementPagination> associated;

    public ElementPaginationBuilderImpl(@NotNull SourceProvider<T> sourceProvider, @NotNull Function<ElementPaginationBuilder<T>, StatePagination> stateFactory) {
        this.sourceProvider = sourceProvider;
        this.stateFactory = stateFactory;
    }

    @Override
    public void associated(@NotNull State<ElementPagination> associated) {
        this.associated = associated;
    }

    @NotNull
    public ElementPaginationBuilder<T> layout(char layout) {
        this.layout = layout;
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> onPageSwitch(@NotNull BiConsumer<ContextBase, ElementPagination> onPageSwitch) {
        this.onPageSwitch = onPageSwitch;
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> elementConfigurer(@NotNull BiConsumer<ElementItemBuilder, T> configurer) {
        return this.elementConfigurer((__, b, ___, ____, value) -> configurer.accept(b, value));
    }

    @NotNull
    public ElementPaginationBuilder<T> elementConfigurer(@NotNull PaginationElementConfigurer<T> configurer) {
        this.elementConfigurer = configurer;
        return this;
    }

    @NotNull
    public StatePagination buildPagination() {
        return this.stateFactory.apply(this);
    }

    @NotNull
    public ElementPagination build(@NotNull ContextBase parent) {
        return new ElementPaginationImpl(this, parent);
    }

    @NotNull
    public ElementPaginationBuilder<T> cancelOnClick() {
        super.cancelOnClick();
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> closeOnClick() {
        super.closeOnClick();
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> updateOnClick() {
        super.updateOnClick();
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> cancelOnClick(boolean cancelOnClick) {
        super.cancelOnClick(cancelOnClick);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> closeOnClick(boolean cancelOnClick) {
        super.closeOnClick(cancelOnClick);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> updateOnClick(boolean updateOnClick) {
        super.updateOnClick(updateOnClick);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> interactionDelay(@Nullable Duration interactionDelay) {
        super.interactionDelay(interactionDelay);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> onInteractionDelay(@NotNull Consumer<ContextElementClick> onInteractionDelay) {
        super.onInteractionDelay(onInteractionDelay);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> interactionDelayKey(@NotNull Function<ContextElementClick, String> interactionDelayKey) {
        super.interactionDelayKey(interactionDelayKey);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> updateOnStateChange(@NotNull State<?> state, State<?> ... otherStates) {
        super.updateOnStateChange(state, otherStates);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> updateOnStateAccess(@NotNull State<?> state, State<?> ... otherStates) {
        super.updateOnStateAccess(state, otherStates);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> displayIf(@NotNull Predicate<ContextElementRender> condition) {
        super.displayIf(condition);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> displayIf(@NotNull BooleanSupplier condition) {
        super.displayIf(condition);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> hideIf(@NotNull Predicate<ContextElementRender> condition) {
        super.hideIf(condition);
        return this;
    }

    @NotNull
    public ElementPaginationBuilder<T> hideIf(@NotNull BooleanSupplier condition) {
        super.hideIf(condition);
        return this;
    }
}

