/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.task;

import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.infumia.frame.task.TaskFactory;
import net.infumia.frame.util.Ticks;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class TaskFactoryImpl
implements TaskFactory {
    private final Plugin plugin;

    public TaskFactoryImpl(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public <T> CompletableFuture<T> handleFuture(@NotNull Supplier<CompletableFuture<T>> task) {
        if (Bukkit.isPrimaryThread()) {
            return task.get();
        }
        CompletableFuture future = new CompletableFuture();
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            try {
                Object result = ((CompletableFuture)task.get()).join();
                future.complete(result);
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @NotNull
    public Closeable run(@NotNull Runnable task, @NotNull Duration delay, @NotNull Duration period) {
        return () -> ((BukkitTask)Bukkit.getScheduler().runTaskTimer(this.plugin, task, (long)Ticks.toTicks((Duration)delay), (long)Ticks.toTicks((Duration)period))).cancel();
    }
}

