/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.service.view;

import net.infumia.frame.Preconditions;
import net.infumia.frame.pipeline.PipelineServiceConsumer;
import net.infumia.frame.pipeline.context.PipelineContextView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceProcessConfigModifierAddSizeModifier
implements PipelineServiceConsumer<PipelineContextView.ProcessConfigModifier> {
    public static final PipelineServiceConsumer<PipelineContextView.ProcessConfigModifier> INSTANCE = new ServiceProcessConfigModifierAddSizeModifier();
    public static final String KEY = "add-size-modifier";

    @NotNull
    public String key() {
        return KEY;
    }

    public void accept(@NotNull PipelineContextView.ProcessConfigModifier ctx) {
        ctx.context().modifyConfig().addModifier((builder, context) -> {
            String @Nullable [] layout = builder.layout();
            if (layout == null) {
                return;
            }
            int layoutLength = layout.length;
            if (layoutLength == 0) {
                return;
            }
            int size = builder.size();
            Preconditions.state((size <= 0 || size == layoutLength ? 1 : 0) != 0, (String)"The layout length '%s' differs from the set inventory size '%s'!", (Object[])new Object[]{layoutLength, size});
            context.frame().logger().debug("View's '%s' size modified according to the layout length '%s'.", new Object[]{context.view().instance(), layoutLength});
            builder.size(layoutLength);
        });
    }

    private ServiceProcessConfigModifierAddSizeModifier() {
    }
}

