/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.executor;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.pipeline.context.PipelineContextViewer;
import net.infumia.frame.pipeline.context.PipelineContextViewers;
import net.infumia.frame.pipeline.executor.PipelineExecutorViewer;
import net.infumia.frame.pipeline.holder.PipelineHolderViewer;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.viewer.Viewer;
import org.jetbrains.annotations.NotNull;

public final class PipelineExecutorViewerImpl
implements PipelineExecutorViewer {
    private final PipelineHolderViewer pipelines = PipelineHolderViewer.BASE.cloned();
    private final ContextRender context;

    public PipelineExecutorViewerImpl(@NotNull ContextRender context) {
        this.context = context;
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeAdded(@NotNull Collection<Viewer> viewers) {
        return this.pipelines.added().completeWith((Object)new PipelineContextViewers.Added(this.context, viewers));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeRemoved(@NotNull Collection<Viewer> viewers) {
        return this.pipelines.removed().completeWith((Object)new PipelineContextViewers.Removed(this.context, viewers));
    }

    public void applyAdded(@NotNull Implementation<PipelineContextViewer.Added, ConsumerService.State> implementation) {
        this.pipelines.added().apply(implementation);
    }

    public void applyRemoved(@NotNull Implementation<PipelineContextViewer.Removed, ConsumerService.State> implementation) {
        this.pipelines.removed().apply(implementation);
    }
}

