/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element.item;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.infumia.frame.Preconditions;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.element.ContextElementItemClick;
import net.infumia.frame.context.element.ContextElementItemRender;
import net.infumia.frame.context.element.ContextElementItemUpdate;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementEventHandler;
import net.infumia.frame.element.ElementImpl;
import net.infumia.frame.element.item.ElementEventHandlerItem;
import net.infumia.frame.element.item.ElementItem;
import net.infumia.frame.element.item.ElementItemBuilderImpl;
import net.infumia.frame.element.item.ElementItemRich;
import net.infumia.frame.pipeline.executor.PipelineExecutorElement;
import net.infumia.frame.pipeline.executor.PipelineExecutorElementImpl;
import net.infumia.frame.service.ConsumerService;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementItemImpl
extends ElementImpl
implements ElementItemRich {
    private final PipelineExecutorElement pipelines = new PipelineExecutorElementImpl(this);
    private final ElementEventHandler eventHandler = ElementEventHandlerItem.INSTANCE;
    final ItemStack item;
    final int slot;
    final Consumer<ContextElementItemClick> onClick;
    final Consumer<ContextElementItemRender> onRender;
    final Consumer<ContextElementItemUpdate> onUpdate;

    ElementItemImpl(@NotNull ElementItemBuilderImpl builder, @NotNull ContextBase parent) {
        super(builder, parent);
        this.item = (ItemStack)Preconditions.argumentNotNull((Object)builder.item, (String)"Item is not set!", (Object[])new Object[0]);
        this.slot = builder.slot;
        this.onClick = builder.onClick;
        this.onRender = builder.onRender;
        this.onUpdate = builder.onUpdate;
    }

    @NotNull
    public ItemStack item() {
        return this.item;
    }

    public int slot() {
        return this.slot;
    }

    @Nullable
    public Consumer<ContextElementItemClick> onClick() {
        return this.onClick;
    }

    @Nullable
    public Consumer<ContextElementItemRender> onRender() {
        return this.onRender;
    }

    @Nullable
    public Consumer<ContextElementItemUpdate> onUpdate() {
        return this.onUpdate;
    }

    @Override
    @NotNull
    public ElementEventHandler eventHandler() {
        return this.eventHandler;
    }

    @Override
    public boolean containedWithin(int slot) {
        return this.slot == slot;
    }

    @Override
    public boolean intersects(@NotNull Element element) {
        if (!(element instanceof ElementItem)) {
            return false;
        }
        return ((ElementItem)element).slot() == this.slot;
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> update() {
        Preconditions.state((boolean)(this.parent instanceof ContextRender), (String)"You cannot update the element '%s' when the parent is not a ContextRender!", (Object[])new Object[]{this});
        return this.pipelines.executeUpdate((ContextRender)this.parent, false);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> forceUpdate() {
        Preconditions.state((boolean)(this.parent instanceof ContextRender), (String)"You cannot update the element '%s' when the parent is not a ContextRender!", (Object[])new Object[]{this});
        return this.pipelines.executeUpdate((ContextRender)this.parent, true);
    }

    @Override
    @NotNull
    public PipelineExecutorElement pipelines() {
        return this.pipelines;
    }
}

