/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element.item;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.infumia.frame.Preconditions;
import net.infumia.frame.context.element.ContextElementClick;
import net.infumia.frame.context.element.ContextElementItemClickImpl;
import net.infumia.frame.context.element.ContextElementItemRenderImpl;
import net.infumia.frame.context.element.ContextElementItemUpdateImpl;
import net.infumia.frame.context.element.ContextElementRender;
import net.infumia.frame.context.element.ContextElementUpdate;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementContainer;
import net.infumia.frame.element.ElementEventHandler;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.element.item.ElementItemRich;
import net.infumia.frame.pipeline.context.PipelineContextElement;
import net.infumia.frame.pipeline.executor.PipelineExecutorElement;
import net.infumia.frame.service.ConsumerService;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

final class ElementEventHandlerItem
implements ElementEventHandler {
    static final ElementEventHandler INSTANCE = new ElementEventHandlerItem();

    private ElementEventHandlerItem() {
    }

    @Override
    @NotNull
    public CompletableFuture<?> handleRender(@NotNull PipelineContextElement.Render ctx) {
        ContextElementRender context = ctx.context();
        ElementItemRich element = (ElementItemRich)context.element();
        if (element.shouldRender(context)) {
            this.renderInternally(element, context);
            return CompletableFuture.completedFuture(null);
        }
        element.visible(false);
        return this.checkOverlapping(element, context);
    }

    @Override
    @NotNull
    public CompletableFuture<?> handleClear(@NotNull PipelineContextElement.Clear ctx) {
        ctx.context().container().removeItem(((ElementItemRich)ctx.context().element()).slot());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    @NotNull
    public CompletableFuture<?> handleClick(@NotNull PipelineContextElement.Click ctx) {
        ContextElementClick context = ctx.context();
        ElementItemRich element = (ElementItemRich)context.element();
        Consumer onClick = element.onClick();
        if (onClick != null) {
            onClick.accept(new ContextElementItemClickImpl(context, element));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    @NotNull
    public CompletableFuture<?> handleUpdate(@NotNull PipelineContextElement.Update ctx) {
        ContextElementUpdate context = ctx.context();
        ElementItemRich element = (ElementItemRich)context.element();
        if (!context.forced() && element.displayIf() == null && element.onRender() == null) {
            return CompletableFuture.completedFuture(null);
        }
        Consumer onUpdate = element.onUpdate();
        if (element.visible() && onUpdate != null) {
            onUpdate.accept(new ContextElementItemUpdateImpl(context, element));
        }
        if (context.cancelled()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((PipelineExecutorElement)element.pipelines()).executeRender((ContextRender)context, context.forced());
    }

    @NotNull
    private CompletableFuture<ConsumerService.State> checkOverlapping(@NotNull ElementRich compareTo, @NotNull ContextElementRender context) {
        Optional<ElementRich> overlappingOptional = this.findOverlappingElement(compareTo, context);
        if (!overlappingOptional.isPresent()) {
            return ((PipelineExecutorElement)compareTo.pipelines()).executeClear((ContextRender)context);
        }
        ElementRich overlapping = overlappingOptional.get();
        return ((PipelineExecutorElement)overlapping.pipelines()).executeRender((ContextRender)context, false).thenCompose(__ -> {
            if (overlapping.visible()) {
                return CompletableFuture.completedFuture(null);
            }
            return ((PipelineExecutorElement)compareTo.pipelines()).executeClear((ContextRender)context);
        });
    }

    @NotNull
    private Optional<ElementRich> findOverlappingElement(@NotNull ElementRich compareTo, @NotNull ContextElementRender context) {
        for (Element child : context.elements()) {
            ElementRich element = (ElementRich)child;
            if (!element.visible()) continue;
            if (element instanceof ElementContainer) {
                ElementRich root = (ElementRich)compareTo.root();
                if (root != null && Objects.equals(element.key(), root.key())) continue;
                for (Element deepChild : ((ElementContainer)element).elements()) {
                    ElementRich deepElement = (ElementRich)deepChild;
                    if (!deepElement.visible() || Objects.equals(deepElement.key(), compareTo.key()) || !deepElement.intersects(compareTo)) continue;
                    return Optional.of(deepElement);
                }
                continue;
            }
            if (Objects.equals(element.key(), compareTo.key()) || !element.intersects(compareTo)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    private void renderInternally(@NotNull ElementItemRich element, @NotNull ContextElementRender delegate) {
        ContextElementItemRenderImpl context = new ContextElementItemRenderImpl(delegate, element);
        Consumer onRender = element.onRender();
        if (onRender != null) {
            onRender.accept(context);
        }
        ItemStack modifiedItem = context.modifiedItem();
        int modifiedSlot = context.modifiedSlot();
        Preconditions.state((modifiedSlot != -1 ? 1 : 0) != 0, (String)"Element's '%s' slot is not set!", (Object[])new Object[]{element});
        delegate.container().addItem(modifiedSlot, modifiedItem);
        element.visible(true);
    }
}

