/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.metadata;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.infumia.frame.metadata.CacheKeyExtractor;
import net.infumia.frame.metadata.CacheKeyExtractorEntityUniqueId;
import net.infumia.frame.metadata.MetadataAccess;
import net.infumia.frame.metadata.MetadataAccessFactory;
import net.infumia.frame.metadata.MetadataAccessImpl;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class MetadataAccessFactoryImpl
implements MetadataAccessFactory {
    private final Map<String, MetadataAccess> cache = new ConcurrentHashMap<String, MetadataAccess>();
    private final Plugin plugin;
    private final CacheKeyExtractor cacheKeyExtractor;

    public MetadataAccessFactoryImpl(@NotNull Plugin plugin, @NotNull CacheKeyExtractor cacheKeyExtractor) {
        this.plugin = plugin;
        this.cacheKeyExtractor = cacheKeyExtractor;
    }

    public MetadataAccessFactoryImpl(@NotNull Plugin plugin) {
        this(plugin, new CacheKeyExtractorEntityUniqueId());
    }

    @NotNull
    public MetadataAccess getOrCreate(@NotNull Metadatable metadatable) {
        return this.cache.computeIfAbsent((String)this.cacheKeyExtractor.apply((Object)metadatable), __ -> new MetadataAccessImpl(this.plugin, metadatable));
    }

    public void clearCache(@NotNull Collection<? extends Metadatable> list) {
        list.stream().map(this.cacheKeyExtractor).map(this.cache::remove).filter(Objects::nonNull).forEach(MetadataAccess::removeAll);
    }
}

