/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.listener;

import java.util.function.Consumer;
import net.infumia.frame.Frame;
import net.infumia.frame.metadata.MetadataAccess;
import net.infumia.frame.metadata.MetadataAccessFactory;
import net.infumia.frame.metadata.MetadataKeyHolder;
import net.infumia.frame.view.InventoryHolderView;
import net.infumia.frame.view.ViewEventHandler;
import net.infumia.frame.viewer.ContextualViewer;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class InventoryListener
implements Listener {
    private final Plugin plugin;
    private final MetadataAccessFactory metadataAccessFactory;
    private final boolean unregisterOnDisable;
    private final Frame frame;

    public InventoryListener(@NotNull Frame frame, @NotNull Plugin plugin, @NotNull MetadataAccessFactory metadataAccessFactory, boolean unregisterOnDisable) {
        this.frame = frame;
        this.plugin = plugin;
        this.metadataAccessFactory = metadataAccessFactory;
        this.unregisterOnDisable = unregisterOnDisable;
    }

    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (this.unregisterOnDisable && event.getPlugin().getName().equals(this.plugin.getName())) {
            this.frame.unregister();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof InventoryHolderView)) {
            return;
        }
        this.ifTransitioning((Metadatable)event.getPlayer(), viewer -> this.frame.loggedFuture(((ViewEventHandler)viewer.view()).simulateClose((ContextualViewer)viewer), "Error occurred while viewer '%s' closes an inventory", new Object[]{viewer}));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof InventoryHolderView)) {
            return;
        }
        this.ifContextualViewer((Metadatable)event.getWhoClicked(), viewer -> this.frame.loggedFuture(((ViewEventHandler)viewer.view()).simulateClick((ContextualViewer)viewer, event), "Error occurred while viewer '%s' clicks an inventory!", new Object[]{viewer}));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof InventoryHolderView)) {
            return;
        }
        this.ifContextualViewer((Metadatable)event.getWhoClicked(), viewer -> ((ViewEventHandler)viewer.view()).handleInventoryDrag((ContextualViewer)viewer, event));
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemPickup(PlayerPickupItemEvent event) {
        this.ifContextualViewer((Metadatable)event.getPlayer(), viewer -> ((ViewEventHandler)viewer.view()).handleItemPickup((ContextualViewer)viewer, event));
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent event) {
        this.ifContextualViewer((Metadatable)event.getPlayer(), viewer -> ((ViewEventHandler)viewer.view()).handleItemDrop((ContextualViewer)viewer, event));
    }

    private void ifContextualViewer(@NotNull Metadatable metadatable, @NotNull Consumer<ContextualViewer> consumer) {
        ContextualViewer viewer = (ContextualViewer)this.metadataAccessFactory.getOrCreate(metadatable).get(MetadataKeyHolder.CONTEXTUAL_VIEWER);
        if (viewer != null) {
            consumer.accept(viewer);
        }
    }

    private void ifTransitioning(@NotNull Metadatable metadatable, @NotNull Consumer<ContextualViewer> consumer) {
        MetadataAccess access = this.metadataAccessFactory.getOrCreate(metadatable);
        ContextualViewer transitioningFrom = (ContextualViewer)access.get(MetadataKeyHolder.TRANSITIONING_FROM);
        if (transitioningFrom == null) {
            this.ifContextualViewer(metadatable, consumer);
        } else {
            consumer.accept(transitioningFrom);
        }
    }
}

