/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element.pagination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.context.element.ContextElementClear;
import net.infumia.frame.context.element.ContextElementClick;
import net.infumia.frame.context.element.ContextElementRender;
import net.infumia.frame.context.element.ContextElementUpdate;
import net.infumia.frame.context.view.ContextClick;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementEventHandler;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.element.pagination.ElementPaginationRich;
import net.infumia.frame.pipeline.context.PipelineContextElement;
import net.infumia.frame.pipeline.executor.PipelineExecutorElement;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.state.StateRich;
import net.infumia.frame.state.value.StateValueHostHolder;
import org.jetbrains.annotations.NotNull;

final class ElementEventHandlerPagination
implements ElementEventHandler {
    static final ElementEventHandler INSTANCE = new ElementEventHandlerPagination();

    private ElementEventHandlerPagination() {
    }

    @Override
    @NotNull
    public CompletableFuture<?> handleRender(@NotNull PipelineContextElement.Render ctx) {
        ContextElementRender context = ctx.context();
        ElementPaginationRich pagination = (ElementPaginationRich)context.element();
        boolean forced = context.forced();
        if (pagination.initialized() && !pagination.pageWasChanged() && !forced) {
            pagination.visible(true);
            return this.renderChild(context, pagination);
        }
        if (!pagination.initialized()) {
            pagination.updatePageSize((ContextRender)context);
        }
        return pagination.loadCurrentPage((ContextRender)context, forced).thenCompose(__ -> {
            pagination.visible(true);
            pagination.initialized(true);
            return ((CompletableFuture)this.renderChild(context, pagination).thenCompose(s -> ((StateRich)pagination.associated()).manualUpdateWait((StateValueHostHolder)context))).thenApply(v -> null);
        });
    }

    @Override
    @NotNull
    public CompletableFuture<?> handleClear(@NotNull PipelineContextElement.Clear ctx) {
        ContextElementClear context = ctx.context();
        ElementPaginationRich pagination = (ElementPaginationRich)context.element();
        if (!pagination.pageWasChanged()) {
            List elements = pagination.elements();
            CompletableFuture[] futures = new CompletableFuture[elements.size()];
            for (int i = 0; i < futures.length; ++i) {
                futures[i] = ((PipelineExecutorElement)((ElementRich)elements.get(i)).pipelines()).executeClear((ContextRender)context);
            }
            return CompletableFuture.allOf(futures);
        }
        Collection<Element> elements = pagination.modifiableElements();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        Iterator<Element> iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            futures.add(((PipelineExecutorElement)((ElementRich)element).pipelines()).executeClear((ContextRender)context));
            iterator.remove();
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    @Override
    @NotNull
    public CompletableFuture<?> handleClick(@NotNull PipelineContextElement.Click ctx) {
        ContextElementClick context = ctx.context();
        ElementPaginationRich pagination = (ElementPaginationRich)context.element();
        if (pagination.pageWasChanged() || !pagination.visible()) {
            ctx.cancelled(true);
            context.cancelled(true);
            return CompletableFuture.completedFuture(null);
        }
        for (Element child : pagination.elements()) {
            ElementRich element = (ElementRich)child;
            if (!element.containedWithin(context.clickedSlotRaw()) || !element.visible()) continue;
            return ((PipelineExecutorElement)element.pipelines()).executeClick((ContextClick)context);
        }
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> handleUpdate(@NotNull PipelineContextElement.Update ctx) {
        ContextElementUpdate context = ctx.context();
        ElementPaginationRich pagination = (ElementPaginationRich)context.element();
        boolean forced = context.forced();
        if (pagination.pageWasChanged() || forced) {
            return ((CompletableFuture)((PipelineExecutorElement)pagination.pipelines()).executeClear((ContextRender)context).thenCompose(__ -> {
                pagination.clearElements();
                return ((PipelineExecutorElement)pagination.pipelines()).executeRender((ContextRender)context, forced);
            })).thenApply(__ -> {
                pagination.pageWasChanged(false);
                return null;
            });
        }
        if (!pagination.visible()) {
            return CompletableFuture.completedFuture(null);
        }
        List elements = pagination.elements();
        CompletableFuture[] futures = new CompletableFuture[elements.size()];
        for (int i = 0; i < futures.length; ++i) {
            futures[i] = ((Element)elements.get(i)).update();
        }
        return CompletableFuture.allOf(futures).thenApply(__ -> null);
    }

    @NotNull
    private CompletableFuture<ConsumerService.State> renderChild(@NotNull ContextElementRender context, @NotNull ElementPaginationRich pagination) {
        List elements = pagination.elements();
        CompletableFuture[] futures = new CompletableFuture[elements.size()];
        for (int i = 0; i < futures.length; ++i) {
            ElementRich element = (ElementRich)elements.get(i);
            futures[i] = ((PipelineExecutorElement)element.pipelines()).executeRender((ContextRender)context, context.forced());
        }
        return CompletableFuture.allOf(futures).thenApply(__ -> null);
    }
}

