/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.logger;

import java.util.logging.Level;
import net.infumia.frame.logger.Logger;
import net.infumia.frame.util.PaperLib;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PluginLogger
implements Logger {
    @NotNull
    private final Plugin plugin;
    private boolean debug = false;

    public PluginLogger(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    public synchronized boolean isDebugEnabled() {
        return this.debug;
    }

    public synchronized void enableDebug(boolean enable) {
        this.debug = enable;
    }

    public void error(@NotNull Throwable throwable, @NotNull String message, Object ... args) {
        if (PaperLib.isPaper()) {
            this.plugin.getSLF4JLogger().error(String.format(message, args), throwable);
        } else {
            this.plugin.getLogger().log(Level.SEVERE, String.format(message, args), throwable);
        }
    }

    public void error(@NotNull String message, Object ... args) {
        if (PaperLib.isPaper()) {
            this.plugin.getSLF4JLogger().error(String.format(message, args));
        } else {
            this.plugin.getLogger().severe(String.format(message, args));
        }
    }

    public void warn(@NotNull String message, Object ... args) {
        if (PaperLib.isPaper()) {
            this.plugin.getSLF4JLogger().warn(String.format(message, args));
        } else {
            this.plugin.getLogger().warning(String.format(message, args));
        }
    }

    public void info(@NotNull String message, Object ... args) {
        if (PaperLib.isPaper()) {
            this.plugin.getSLF4JLogger().info(String.format(message, args));
        } else {
            this.plugin.getLogger().info(String.format(message, args));
        }
    }

    public void debug(@NotNull String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.info(message, args);
        }
    }
}

