/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.element.ContextElementItemClick;
import net.infumia.frame.context.element.ContextElementItemRender;
import net.infumia.frame.context.element.ContextElementItemUpdate;
import net.infumia.frame.context.element.ContextElementRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementBuilderImpl;
import net.infumia.frame.element.ElementItem;
import net.infumia.frame.element.ElementItemBuilder;
import net.infumia.frame.element.ElementItemBuilderRich;
import net.infumia.frame.element.ElementItemImpl;
import net.infumia.frame.state.State;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ElementItemBuilderImpl
extends ElementBuilderImpl
implements ElementItemBuilderRich {
    ItemStack item;
    int slot = -1;
    Consumer<ContextElementItemClick> onClick;
    Consumer<ContextElementItemRender> onRender;
    Consumer<ContextElementItemUpdate> onUpdate;

    ElementItemBuilderImpl(@NotNull ElementItemImpl element) {
        super(element);
        this.item = element.item;
        this.slot = element.slot;
        this.onClick = element.onClick;
        this.onRender = element.onRender;
        this.onUpdate = element.onUpdate;
    }

    public ElementItemBuilderImpl() {
    }

    @Override
    public int slot() {
        return this.slot;
    }

    @NotNull
    public ElementItemBuilderImpl item(@Nullable ItemStack item) {
        this.item = item;
        return this;
    }

    @NotNull
    public ElementItemBuilderImpl slot(int slot) {
        this.slot = slot;
        return this;
    }

    @NotNull
    public ElementItemBuilder onClick(@NotNull Consumer<ContextElementItemClick> onClick) {
        this.onClick = onClick;
        return this;
    }

    @NotNull
    public ElementItemBuilder onClick(@NotNull Runnable onClick) {
        return this.onClick((ContextElementItemClick __) -> onClick.run());
    }

    @NotNull
    public ElementItemBuilderImpl onRender(@Nullable Consumer<ContextElementItemRender> onRender) {
        this.onRender = onRender;
        return this;
    }

    @NotNull
    public ElementItemBuilder renderWith(@NotNull Function<ContextElementItemRender, ItemStack> renderWith) {
        return this.onRender(ctx -> ctx.modifyItem((ItemStack)renderWith.apply((ContextElementItemRender)ctx)));
    }

    @NotNull
    public ElementItemBuilder onUpdate(@Nullable Consumer<ContextElementItemUpdate> onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    @NotNull
    public ElementItemBuilder root(@NotNull Element root) {
        super.root(root);
        return this;
    }

    @Override
    @NotNull
    public ElementItem build(@NotNull ContextBase parent) {
        return new ElementItemImpl(this, parent);
    }

    @NotNull
    public ElementItemBuilder cancelOnClick() {
        super.cancelOnClick();
        return this;
    }

    @NotNull
    public ElementItemBuilder closeOnClick() {
        super.closeOnClick();
        return this;
    }

    @NotNull
    public ElementItemBuilder updateOnClick() {
        super.updateOnClick();
        return this;
    }

    @NotNull
    public ElementItemBuilder cancelOnClick(boolean cancelOnClick) {
        super.cancelOnClick(cancelOnClick);
        return this;
    }

    @NotNull
    public ElementItemBuilder closeOnClick(boolean cancelOnClick) {
        super.closeOnClick(cancelOnClick);
        return this;
    }

    @NotNull
    public ElementItemBuilder updateOnClick(boolean updateOnClick) {
        super.updateOnClick(updateOnClick);
        return this;
    }

    @NotNull
    public ElementItemBuilder updateOnStateChange(@NotNull State<?> state, State<?> ... otherStates) {
        super.updateOnStateChange(state, otherStates);
        return this;
    }

    @NotNull
    public ElementItemBuilder updateOnStateAccess(@NotNull State<?> state, State<?> ... otherStates) {
        super.updateOnStateAccess(state, otherStates);
        return this;
    }

    @NotNull
    public ElementItemBuilder displayIf(@NotNull Predicate<ContextElementRender> condition) {
        super.displayIf(condition);
        return this;
    }

    @NotNull
    public ElementItemBuilder displayIf(@NotNull BooleanSupplier condition) {
        super.displayIf(condition);
        return this;
    }

    @NotNull
    public ElementItemBuilder hideIf(@NotNull Predicate<ContextElementRender> condition) {
        super.hideIf(condition);
        return this;
    }

    @NotNull
    public ElementItemBuilder hideIf(@NotNull BooleanSupplier condition) {
        super.hideIf(condition);
        return this;
    }
}

