/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.config;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.infumia.frame.config.ViewConfigBuilderRich;
import net.infumia.frame.config.ViewConfigImpl;
import net.infumia.frame.config.ViewConfigRich;
import net.infumia.frame.type.InvType;
import net.infumia.frame.util.Preconditions;
import net.infumia.frame.util.Reflection;
import net.infumia.frame.view.config.ViewConfigBuilder;
import net.infumia.frame.view.config.ViewConfigModifier;
import net.infumia.frame.view.config.option.ViewConfigOption;
import net.infumia.frame.view.config.option.ViewConfigOptions;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

final class ViewConfigBuilderImpl
implements ViewConfigBuilderRich {
    private static final boolean COMPONENT_SUPPORT = Reflection.hasClass((String)"net.kyori.adventure.text.Component");
    final Map<ViewConfigOption<Object>, Object> options;
    final Collection<ViewConfigModifier> modifiers;
    Object title;
    int size = -1;
    InvType type = InvType.CHEST;
    String[] layout;
    Duration updateInterval;
    Duration interactionDelay;

    ViewConfigBuilderImpl(@NotNull ViewConfigImpl config) {
        this.options = new HashMap<ViewConfigOption<Object>, Object>(config.options);
        this.modifiers = new HashSet<ViewConfigModifier>(config.modifiers);
        this.title = config.title;
        this.size = config.size;
        this.type = config.type;
        this.layout = config.layout;
        this.updateInterval = config.updateInterval;
        this.interactionDelay = config.interactionDelay;
    }

    ViewConfigBuilderImpl() {
        this.options = new HashMap<ViewConfigOption<Object>, Object>();
        this.modifiers = new HashSet<ViewConfigModifier>();
    }

    @Nullable
    public Object title() {
        return this.title;
    }

    public int size() {
        return this.size;
    }

    public @NotNull String @Nullable [] layout() {
        return this.layout;
    }

    @NotNull
    public InvType type() {
        return this.type;
    }

    @Nullable
    public Duration updateInterval() {
        return this.updateInterval;
    }

    @Nullable
    public Duration interactionDelay() {
        return this.interactionDelay;
    }

    @NotNull
    public @UnmodifiableView Map<ViewConfigOption<Object>, Object> options() {
        return Collections.unmodifiableMap(this.options);
    }

    @NotNull
    public @UnmodifiableView Collection<ViewConfigModifier> modifiers() {
        return Collections.unmodifiableCollection(this.modifiers);
    }

    @NotNull
    public ViewConfigBuilderRich title(@NotNull Object title) {
        ViewConfigBuilderImpl.checkTitleType(title);
        this.title = title;
        return this;
    }

    @NotNull
    public ViewConfigBuilder layout(@NotNull String @Nullable [] layout) {
        this.layout = layout;
        return this;
    }

    @NotNull
    public ViewConfigBuilder size(int size) {
        this.size = size;
        return this;
    }

    @NotNull
    public ViewConfigBuilder type(@NotNull InvType type) {
        this.type = type;
        return this;
    }

    @NotNull
    public ViewConfigBuilder updateInterval(@NotNull Duration updateInterval) {
        this.updateInterval = updateInterval;
        return this;
    }

    @NotNull
    public ViewConfigBuilder interactionDelay(@NotNull Duration interactionDelay) {
        this.interactionDelay = interactionDelay;
        return this;
    }

    @NotNull
    public ViewConfigBuilderRich cancelOnClick() {
        return this.addOption(ViewConfigOptions.CANCEL_ON_CLICK);
    }

    @NotNull
    public ViewConfigBuilderRich cancelOnPickup() {
        return this.addOption(ViewConfigOptions.CANCEL_ON_PICKUP);
    }

    @NotNull
    public ViewConfigBuilderRich cancelOnDrop() {
        return this.addOption(ViewConfigOptions.CANCEL_ON_DROP);
    }

    @NotNull
    public ViewConfigBuilderRich cancelOnDrag() {
        return this.addOption(ViewConfigOptions.CANCEL_ON_DRAG);
    }

    @NotNull
    public ViewConfigBuilderRich cancelDefaults() {
        this.cancelOnClick().cancelOnPickup().cancelOnDrop().cancelOnDrag();
        return this;
    }

    @NotNull
    public <T> ViewConfigBuilderRich addOption(@NotNull ViewConfigOption<T> option) {
        return this.addOption((ViewConfigOption)option, Preconditions.argumentNotNull((Object)option.defaultValue(), (String)"Option '%s' does not have a default value! Please use #addOption(ViewConfigOption<T>, T) method instead!", (Object[])new Object[0]));
    }

    @NotNull
    public <T> ViewConfigBuilderRich addOption(@NotNull ViewConfigOption<T> option, @NotNull T value) {
        this.options.put(option, value);
        return this;
    }

    @NotNull
    public ViewConfigBuilderRich addModifier(@NotNull ViewConfigModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    @NotNull
    public ViewConfigBuilderRich addModifier(ViewConfigModifier ... modifiers) {
        Collections.addAll(this.modifiers, modifiers);
        return this;
    }

    @Override
    @NotNull
    public ViewConfigRich build() {
        return new ViewConfigImpl(this);
    }

    private static void checkTitleType(@NotNull Object title) {
        boolean check = title instanceof String;
        if (COMPONENT_SUPPORT) {
            check |= title instanceof Component;
        }
        Preconditions.argument((boolean)check, (String)"Title must be only String or Component!", (Object[])new Object[0]);
    }
}

