/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.task;

import java.io.Closeable;
import java.time.Duration;
import net.infumia.frame.logger.Logger;
import net.infumia.frame.task.TaskFactory;
import net.infumia.frame.util.RunnableThrowable;
import net.infumia.frame.util.Ticks;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class TaskFactoryImpl
implements TaskFactory {
    private final Plugin plugin;
    private final Logger logger;

    public TaskFactoryImpl(@NotNull Plugin plugin, @NotNull Logger logger) {
        this.plugin = plugin;
        this.logger = logger;
    }

    @NotNull
    public Closeable sync(@NotNull RunnableThrowable task) {
        BukkitTask bukkitTask = Bukkit.getScheduler().runTask(this.plugin, () -> {
            try {
                task.run();
            }
            catch (Throwable e) {
                this.logger.error(e, "An error occurred while running a sync task.", new Object[0]);
            }
        });
        return () -> ((BukkitTask)bukkitTask).cancel();
    }

    @NotNull
    public Closeable sync(@NotNull RunnableThrowable task, @NotNull Duration delay, @NotNull Duration period) {
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            try {
                task.run();
            }
            catch (Throwable e) {
                this.logger.error(e, "An error occurred while running a sync task.", new Object[0]);
            }
        }, (long)Ticks.toTicks((Duration)delay), (long)Ticks.toTicks((Duration)period));
        return () -> ((BukkitTask)bukkitTask).cancel();
    }
}

