/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.service.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.infumia.frame.pipeline.PipelineServiceConsumer;
import net.infumia.frame.pipeline.context.PipelineContextView;
import net.infumia.frame.util.Preconditions;
import net.infumia.frame.view.ViewContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceLayoutResolution
implements PipelineServiceConsumer<PipelineContextView.LayoutResolution> {
    public static final PipelineServiceConsumer<PipelineContextView.LayoutResolution> INSTANCE = new ServiceLayoutResolution();
    public static final String KEY = "layout-resolution";

    public String key() {
        return KEY;
    }

    public void accept(@NotNull PipelineContextView.LayoutResolution ctx) {
        String @Nullable [] layout = ctx.config().layout();
        if (layout == null) {
            return;
        }
        int layoutRows = layout.length;
        if (layoutRows == 0) {
            return;
        }
        ViewContainer container = ctx.container();
        int containerRows = container.rowsCount();
        Preconditions.state((containerRows == layoutRows ? 1 : 0) != 0, (String)"Layout length (%d) must respect the rows count of the container (%d).", (Object[])new Object[]{layoutRows, containerRows});
        HashMap<Character, Collection> layouts = new HashMap<Character, Collection>();
        int containerColumns = container.columnsCount();
        for (int row = 0; row < containerRows; ++row) {
            String layer = layout[row];
            int layerLength = layer.length();
            Preconditions.state((containerColumns == layerLength ? 1 : 0) != 0, (String)"Layout layer length located at %d must respect the columns count of the container (given: %d, expect: %d).", (Object[])new Object[]{row, layerLength, containerColumns});
            for (int column = 0; column < containerColumns; ++column) {
                layouts.computeIfAbsent(Character.valueOf(layer.charAt(column)), ArrayList::new).add(column + row * containerColumns);
            }
        }
        layouts.forEach((arg_0, arg_1) -> ((PipelineContextView.LayoutResolution)ctx).addLayout(arg_0, arg_1));
    }

    private ServiceLayoutResolution() {
    }
}

