/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.service.render;

import java.time.Duration;
import net.infumia.frame.Frame;
import net.infumia.frame.context.view.ContextRenderRich;
import net.infumia.frame.extension.CompletableFutureExtensions;
import net.infumia.frame.pipeline.PipelineServiceConsumer;
import net.infumia.frame.pipeline.context.PipelineContextRender;
import net.infumia.frame.pipeline.executor.PipelineExecutorRender;
import net.infumia.frame.util.Preconditions;
import org.jetbrains.annotations.NotNull;

public final class ServiceStartUpdate
implements PipelineServiceConsumer<PipelineContextRender.StartUpdate> {
    public static final PipelineServiceConsumer<PipelineContextRender.StartUpdate> INSTANCE = new ServiceStartUpdate();
    public static final String KEY = "start-update";

    public String key() {
        return KEY;
    }

    public void accept(@NotNull PipelineContextRender.StartUpdate ctx) {
        ContextRenderRich context = (ContextRenderRich)ctx.context();
        Duration updateInterval = (Duration)Preconditions.stateNotNull((Object)context.config().updateInterval(), (String)"Update interval cannot be null in start-update service!", (Object[])new Object[0]);
        Frame frame = context.frame();
        context.updateTask(frame.taskFactory().sync(() -> CompletableFutureExtensions.logError(((PipelineExecutorRender)context.pipelines()).executeUpdate(), frame.logger(), "An error occurred while running the update task of view '%s'.", context.view().instance()), updateInterval, updateInterval));
    }

    private ServiceStartUpdate() {
    }
}

