/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.executor;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.context.ContextBase;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.context.view.ContextResumeImpl;
import net.infumia.frame.pipeline.PipelineContext;
import net.infumia.frame.pipeline.context.PipelineContextRender;
import net.infumia.frame.pipeline.context.PipelineContextRenders;
import net.infumia.frame.pipeline.context.PipelineContextView;
import net.infumia.frame.pipeline.context.PipelineContextViews;
import net.infumia.frame.pipeline.executor.PipelineExecutorRender;
import net.infumia.frame.pipeline.holder.PipelineHolderRender;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.viewer.Viewer;
import org.jetbrains.annotations.NotNull;

public final class PipelineExecutorRenderImpl
implements PipelineExecutorRender {
    private final PipelineHolderRender pipelines = PipelineHolderRender.BASE.createNew();
    private final ContextRender context;

    public PipelineExecutorRenderImpl(@NotNull ContextRender context) {
        this.context = context;
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeFirstRender() {
        return this.pipelines.firstRender().completeWith((PipelineContext)new PipelineContextRenders.FirstRender(this.context));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeTransition(@NotNull Collection<Viewer> viewers) {
        return this.pipelines.transition().completeWith((PipelineContext)new PipelineContextViews.Transition((ContextBase)this.context, viewers));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeOpenContainer(@NotNull Collection<Viewer> viewers) {
        return this.pipelines.openContainer().completeWith((PipelineContext)new PipelineContextRenders.OpenContainer(this.context, viewers));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeStartUpdate() {
        return this.pipelines.startUpdate().completeWith((PipelineContext)new PipelineContextRenders.StartUpdate(this.context));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeResume(@NotNull ContextRender from, @NotNull Collection<Viewer> viewers) {
        return this.pipelines.resume().completeWith((PipelineContext)new PipelineContextRenders.Resume(new ContextResumeImpl(this.context, from, viewers)));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeStopUpdate() {
        return this.pipelines.stopUpdate().completeWith((PipelineContext)new PipelineContextRenders.StopUpdate(this.context));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeUpdate() {
        return this.pipelines.update().completeWith((PipelineContext)new PipelineContextRenders.Update(this.context));
    }

    public void applyFirstRender(@NotNull Implementation<PipelineContextRender.FirstRender, ConsumerService.State> implementation) {
        this.pipelines.firstRender().apply(implementation);
    }

    public void applyTransition(@NotNull Implementation<PipelineContextView.Transition, ConsumerService.State> implementation) {
        this.pipelines.transition().apply(implementation);
    }

    public void applyOpenContainer(@NotNull Implementation<PipelineContextRender.OpenContainer, ConsumerService.State> implementation) {
        this.pipelines.openContainer().apply(implementation);
    }

    public void applyStartUpdate(@NotNull Implementation<PipelineContextRender.StartUpdate, ConsumerService.State> implementation) {
        this.pipelines.startUpdate().apply(implementation);
    }

    public void applyResume(@NotNull Implementation<PipelineContextRender.Resume, ConsumerService.State> implementation) {
        this.pipelines.resume().apply(implementation);
    }

    public void applyStopUpdate(@NotNull Implementation<PipelineContextRender.StopUpdate, ConsumerService.State> implementation) {
        this.pipelines.stopUpdate().apply(implementation);
    }

    public void applyUpdate(@NotNull Implementation<PipelineContextRender.Update, ConsumerService.State> implementation) {
        this.pipelines.update().apply(implementation);
    }
}

