/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline.executor;

import java.util.concurrent.CompletableFuture;
import net.infumia.frame.context.element.ContextElementClearImpl;
import net.infumia.frame.context.element.ContextElementClickImpl;
import net.infumia.frame.context.element.ContextElementRenderImpl;
import net.infumia.frame.context.element.ContextElementUpdateImpl;
import net.infumia.frame.context.view.ContextClick;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.pipeline.PipelineContext;
import net.infumia.frame.pipeline.context.PipelineContextElement;
import net.infumia.frame.pipeline.context.PipelineContextElements;
import net.infumia.frame.pipeline.executor.PipelineExecutorElement;
import net.infumia.frame.pipeline.holder.PipelineHolderElement;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.service.Implementation;
import org.jetbrains.annotations.NotNull;

public final class PipelineExecutorElementImpl
implements PipelineExecutorElement {
    private final PipelineHolderElement pipelines = PipelineHolderElement.BASE.createNew();
    private final ElementRich element;

    public PipelineExecutorElementImpl(@NotNull ElementRich element) {
        this.element = element;
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeRender(@NotNull ContextRender context) {
        return this.pipelines.render().completeWith((PipelineContext)new PipelineContextElements.Render(new ContextElementRenderImpl(context, this.element)));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeUpdate(@NotNull ContextRender context, boolean forced) {
        return this.pipelines.update().completeWith((PipelineContext)new PipelineContextElements.Update(new ContextElementUpdateImpl(context, this.element, forced)));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeClick(@NotNull ContextClick context) {
        return this.pipelines.click().completeWith((PipelineContext)new PipelineContextElements.Click(new ContextElementClickImpl(context, this.element)));
    }

    @NotNull
    public CompletableFuture<ConsumerService.State> executeClear(@NotNull ContextRender context) {
        return this.pipelines.clear().completeWith((PipelineContext)new PipelineContextElements.Clear(new ContextElementClearImpl(context, this.element)));
    }

    public void applyRender(@NotNull Implementation<PipelineContextElement.Render, ConsumerService.State> implementation) {
        this.pipelines.render().apply(implementation);
    }

    public void applyUpdate(@NotNull Implementation<PipelineContextElement.Update, ConsumerService.State> implementation) {
        this.pipelines.update().apply(implementation);
    }

    public void applyClick(@NotNull Implementation<PipelineContextElement.Click, ConsumerService.State> implementation) {
        this.pipelines.click().apply(implementation);
    }

    public void applyClear(@NotNull Implementation<PipelineContextElement.Clear, ConsumerService.State> implementation) {
        this.pipelines.clear().apply(implementation);
    }
}

