/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.pipeline;

import io.leangen.geantyref.TypeToken;
import java.util.concurrent.CompletableFuture;
import net.infumia.frame.pipeline.Pipeline;
import net.infumia.frame.pipeline.PipelineContext;
import net.infumia.frame.pipeline.PipelineService;
import net.infumia.frame.service.Implementation;
import net.infumia.frame.service.ServicePipelineBuilder;
import net.infumia.frame.service.ServiceRepository;
import org.jetbrains.annotations.NotNull;

public class PipelineImpl<B extends PipelineContext, R>
implements Pipeline<B, R> {
    private final ServiceRepository<B, R> repository;

    public PipelineImpl(@NotNull TypeToken<PipelineService<B, R>> type, @NotNull PipelineService<B, R> defaultService) {
        this.repository = ServicePipelineBuilder.newBuilder().build().create(type, defaultService);
    }

    @NotNull
    public Pipeline<B, R> apply(@NotNull Implementation<B, R> operation) {
        this.repository.apply(operation);
        return this;
    }

    @NotNull
    public CompletableFuture<R> completeWith(@NotNull B context) {
        return this.repository.completeWith(context);
    }

    @NotNull
    public CompletableFuture<R> completeWithAsync(@NotNull B context) {
        return this.repository.completeWithAsync(context);
    }
}

