/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.element;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.infumia.frame.context.element.ContextElementClick;
import net.infumia.frame.context.element.ContextElementItemClickImpl;
import net.infumia.frame.context.element.ContextElementItemRenderImpl;
import net.infumia.frame.context.element.ContextElementItemUpdateImpl;
import net.infumia.frame.context.element.ContextElementRender;
import net.infumia.frame.context.element.ContextElementUpdate;
import net.infumia.frame.context.view.ContextRender;
import net.infumia.frame.element.Element;
import net.infumia.frame.element.ElementContainer;
import net.infumia.frame.element.ElementEventHandler;
import net.infumia.frame.element.ElementItemRich;
import net.infumia.frame.element.ElementRich;
import net.infumia.frame.pipeline.context.PipelineContextElement;
import net.infumia.frame.pipeline.executor.PipelineExecutorElement;
import net.infumia.frame.service.ConsumerService;
import net.infumia.frame.util.Preconditions;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

final class ElementEventHandlerItem
implements ElementEventHandler {
    static final ElementEventHandler INSTANCE = new ElementEventHandlerItem();

    private ElementEventHandlerItem() {
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> handleRender(@NotNull PipelineContextElement.Render ctx) {
        ContextElementRender context = ctx.context();
        ElementItemRich element = (ElementItemRich)context.element();
        if (element.shouldRender(context)) {
            this.forceRender(element, context);
            return CompletableFuture.completedFuture(ConsumerService.State.CONTINUE);
        }
        element.visible(false);
        return this.checkOverlapping(element, context);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> handleClear(@NotNull PipelineContextElement.Clear ctx) {
        ctx.context().container().removeItem(((ElementItemRich)ctx.context().element()).slot());
        return CompletableFuture.completedFuture(ConsumerService.State.CONTINUE);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> handleClick(@NotNull PipelineContextElement.Click ctx) {
        ContextElementClick context = ctx.context();
        ElementItemRich element = (ElementItemRich)context.element();
        Consumer onClick = element.onClick();
        if (onClick != null) {
            onClick.accept(new ContextElementItemClickImpl(context, element));
        }
        return CompletableFuture.completedFuture(ConsumerService.State.CONTINUE);
    }

    @Override
    @NotNull
    public CompletableFuture<ConsumerService.State> handleUpdate(@NotNull PipelineContextElement.Update ctx) {
        ContextElementUpdate context = ctx.context();
        ElementItemRich element = (ElementItemRich)context.element();
        if (!context.forced() && element.displayIf() == null && element.onRender() == null) {
            return CompletableFuture.completedFuture(ConsumerService.State.CONTINUE);
        }
        Consumer onUpdate = element.onUpdate();
        if (element.visible() && onUpdate != null) {
            onUpdate.accept(new ContextElementItemUpdateImpl(context, element));
        }
        if (context.cancelled()) {
            return CompletableFuture.completedFuture(ConsumerService.State.CONTINUE);
        }
        return ((PipelineExecutorElement)element.pipelines()).executeRender((ContextRender)context);
    }

    @NotNull
    private CompletableFuture<ConsumerService.State> checkOverlapping(@NotNull ElementRich compareTo, @NotNull ContextElementRender context) {
        Optional<ElementRich> overlappingOptional = this.findOverlappingElement(compareTo, context);
        if (!overlappingOptional.isPresent()) {
            return ((PipelineExecutorElement)compareTo.pipelines()).executeClear((ContextRender)context);
        }
        ElementRich overlapping = overlappingOptional.get();
        return ((PipelineExecutorElement)overlapping.pipelines()).executeRender((ContextRender)context).thenCompose(__ -> {
            if (overlapping.visible()) {
                return CompletableFuture.completedFuture(ConsumerService.State.CONTINUE);
            }
            return ((PipelineExecutorElement)compareTo.pipelines()).executeClear((ContextRender)context);
        });
    }

    @NotNull
    private Optional<ElementRich> findOverlappingElement(@NotNull ElementRich compareTo, @NotNull ContextElementRender context) {
        for (Element child : context.elements()) {
            ElementRich element = (ElementRich)child;
            if (!element.visible()) continue;
            if (element instanceof ElementContainer) {
                ElementRich root = (ElementRich)compareTo.root();
                if (root != null && Objects.equals(element.key(), root.key())) continue;
                for (Element deepChild : ((ElementContainer)element).elements()) {
                    ElementRich deepElement = (ElementRich)deepChild;
                    if (!deepElement.visible() || Objects.equals(deepElement.key(), compareTo.key()) || !deepElement.intersects(compareTo)) continue;
                    return Optional.of(deepElement);
                }
                continue;
            }
            if (Objects.equals(element.key(), compareTo.key()) || !element.intersects(compareTo)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    private void forceRender(@NotNull ElementItemRich element, @NotNull ContextElementRender delegate) {
        ContextElementItemRenderImpl context = new ContextElementItemRenderImpl(delegate, element);
        Consumer onRender = element.onRender();
        if (onRender != null) {
            onRender.accept(context);
        }
        ItemStack modifiedItem = context.modifiedItem();
        int modifiedSlot = context.modifiedSlot();
        Preconditions.state((modifiedSlot != -1 ? 1 : 0) != 0, (String)"Element's '%s' slot is not set!", (Object[])new Object[]{element});
        delegate.container().addItem(modifiedSlot, modifiedItem);
        element.visible(true);
    }
}

