/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame.config;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.infumia.frame.config.ViewConfigBuilderImpl;
import net.infumia.frame.config.ViewConfigBuilderRich;
import net.infumia.frame.config.ViewConfigRich;
import net.infumia.frame.type.InvType;
import net.infumia.frame.view.config.ViewConfigModifier;
import net.infumia.frame.view.config.option.ViewConfigOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

final class ViewConfigImpl
implements ViewConfigRich {
    final Map<ViewConfigOption<Object>, Object> options;
    final Collection<ViewConfigModifier> modifiers;
    final Object title;
    final int size;
    final InvType type;
    final String[] layout;
    final Duration updateInterval;
    final Duration interactionDelay;

    ViewConfigImpl(@NotNull ViewConfigBuilderImpl builder) {
        this.options = Collections.unmodifiableMap(builder.options);
        this.modifiers = Collections.unmodifiableCollection(builder.modifiers);
        this.title = builder.title;
        this.size = builder.size;
        this.type = builder.type;
        this.layout = builder.layout;
        this.updateInterval = builder.updateInterval;
        this.interactionDelay = builder.interactionDelay;
    }

    @Nullable
    public Object title() {
        return this.title;
    }

    @Override
    @NotNull
    public ViewConfigBuilderRich toBuilder() {
        return new ViewConfigBuilderImpl(this);
    }

    public int size() {
        return this.size;
    }

    public @NotNull String @Nullable [] layout() {
        return this.layout;
    }

    @NotNull
    public InvType type() {
        return this.type;
    }

    @Nullable
    public Duration updateInterval() {
        return this.updateInterval;
    }

    @Nullable
    public Duration interactionDelay() {
        return this.interactionDelay;
    }

    @NotNull
    public @UnmodifiableView Map<ViewConfigOption<Object>, Object> options() {
        return this.options;
    }

    @NotNull
    public @UnmodifiableView Collection<ViewConfigModifier> modifiers() {
        return this.modifiers;
    }

    @NotNull
    public <T> Optional<T> option(@NotNull ViewConfigOption<T> option) {
        return Optional.ofNullable(this.options.get(option)).map(value -> value);
    }

    @NotNull
    public <T> Optional<T> optionOrDefault(@NotNull ViewConfigOption<T> option) {
        Optional<T> value = this.option(option);
        if (value.isPresent()) {
            return value;
        }
        return Optional.ofNullable(option.defaultValue());
    }
}

