/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.frame;

import java.util.function.Supplier;
import net.infumia.frame.Preconditions;

public final class Lazy<T>
implements Supplier<T> {
    private volatile Supplier<T> supplier;
    private volatile boolean initialized = false;
    private T value;

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    private Lazy(T value) {
        this.value = value;
        this.initialized = true;
    }

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<Supplier<T>>(Preconditions.argumentNotNull(supplier, "supplier", new Object[0]));
    }

    public static <T> Lazy<T> of(T value) {
        return new Lazy<T>(Preconditions.argumentNotNull(value, "value", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (!this.initialized) {
                    T t = this.supplier.get();
                    this.value = t;
                    this.initialized = true;
                    this.supplier = null;
                    return t;
                }
            }
        }
        return this.value;
    }
}

