/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.world.region;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.infstudio.infinitylib.api.world.AttachWorldCapEvent;
import net.infstudio.infinitylib.api.world.region.Region;
import net.infstudio.infinitylib.api.world.region.RegionEvent;
import net.infstudio.infinitylib.api.world.region.RegionManager;
import net.infstudio.infinitylib.world.ChunkDataImpl;
import net.infstudio.infinitylib.world.WorldPropertiesManagers;
import net.infstudio.infinitylib.world.region.RegionImpl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RegionManagerImpl
implements RegionManager {
    @CapabilityInject(value=RegionManagerImpl.class)
    public static final Capability<RegionManagerImpl> REGION_MANAGER = null;
    private HashMap<String, RegionImpl> idToRegion = new HashMap();
    private World world;
    private List<String> pendingToRemove = Lists.newLinkedList();

    public RegionManagerImpl(World world) {
        this.world = world;
        if (!world.field_72995_K) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Optional<RegionImpl> getRegion(int x, int z) {
        return Optional.absent();
    }

    private NBTTagList regionsTags(Chunk chunk) {
        ChunkDataImpl data = ChunkDataImpl.getChunkData(chunk);
        if (!data.getTileData().func_74764_b("regions")) {
            NBTTagList lst = data.getTileData().func_150295_c("regions", 8);
            data.getTileData().func_74782_a("regions", (NBTBase)lst);
        }
        return data.getTileData().func_150295_c("regions", 8);
    }

    @Override
    public Optional<RegionImpl> getRegion(BlockPos pos) {
        return null;
    }

    @Override
    public Optional<Region> newRegion(String id, int x1, int z1, int x2, int z2) {
        RegionImpl region = new RegionImpl(id, this);
        if (region.addRegion(x1, z1, x2, z2)) {
            this.idToRegion.put(id, region);
        }
        return Optional.absent();
    }

    @Override
    public void deleteRegion(Region region) {
    }

    protected boolean onRegionExpand(RegionImpl region, List<Chunk> chunks, Rectangle2D area) {
        for (Chunk chunk : chunks) {
            NBTTagList regions = this.regionsTags(chunk);
            RegionImpl r = this.idToRegion.get("");
            if (r.intersect(area)) {
                return false;
            }
            regions.func_74742_a((NBTBase)new NBTTagString(region.getId()));
        }
        return true;
    }

    protected void onRegionSubtract(RegionImpl region, List<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            int i;
            ArrayList removed = Lists.newArrayList();
            NBTTagList list = this.regionsTags(chunk);
            String[] ids = new String[]{};
            for (i = 0; i < ids.length; ++i) {
                if (!ids[i].equals(region.getId())) continue;
                removed.add(i);
            }
            for (i = removed.size() - 1; i >= 0; --i) {
                list.func_74744_a(((Integer)removed.get(i)).intValue());
            }
            removed.clear();
        }
    }

    private static void onPlayerEnterRegion(RegionImpl region, EntityPlayer player) {
        player.getEntityData().func_74778_a("region", region.getId());
        MinecraftForge.EVENT_BUS.post((Event)new RegionEvent.Enter(region, player));
    }

    private static void onPlayerLeaveRegion(RegionImpl region, EntityPlayer player) {
        player.getEntityData().func_74778_a("region", "");
        MinecraftForge.EVENT_BUS.post((Event)new RegionEvent.Leave(region, player));
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        String[] ids;
        Chunk chunk = event.getChunk();
        for (String string : ids = new String[0]) {
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        String[] ids;
        Chunk chunk = event.getChunk();
        for (String id : ids = new String[0]) {
            RegionImpl regionImpl = this.idToRegion.get(id);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.world == this.world) {
            for (EntityPlayer playerEntity : event.world.field_73010_i) {
                if (playerEntity.field_70142_S == playerEntity.field_70165_t && playerEntity.field_70137_T == playerEntity.field_70163_u && playerEntity.field_70136_U == playerEntity.field_70136_U) continue;
                NBTTagCompound entityData = playerEntity.getEntityData();
                String regionId = entityData.func_74779_i("region");
                BlockPos position = playerEntity.func_180425_c();
                Optional<RegionImpl> newRegion = RegionManagerImpl.getInstance(playerEntity.field_70170_p).getRegion(position);
                if (regionId == null || regionId.equals("")) {
                    if (!newRegion.isPresent()) continue;
                    RegionManagerImpl.onPlayerEnterRegion((RegionImpl)newRegion.get(), playerEntity);
                    continue;
                }
                RegionImpl region = this.idToRegion.get(regionId);
                if (newRegion.isPresent()) {
                    if (((RegionImpl)newRegion.get()).equals(region)) continue;
                    RegionManagerImpl.onPlayerLeaveRegion(region, playerEntity);
                    RegionManagerImpl.onPlayerEnterRegion((RegionImpl)newRegion.get(), playerEntity);
                    continue;
                }
                RegionManagerImpl.onPlayerLeaveRegion(region, playerEntity);
            }
        }
    }

    @SubscribeEvent
    public void onWorldCap(AttachWorldCapEvent event) {
        event.addCapability(new ResourceLocation("helper", "region"), (ICapabilityProvider)new RegionManCapProvider(event.getWorld()));
    }

    public static RegionManagerImpl getInstance(World world) {
        return (RegionManagerImpl)WorldPropertiesManagers.instance().getCapabilityProvider(world).getCapability(REGION_MANAGER, null);
    }

    private static class RegionManCapProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        public RegionManagerImpl manager;

        public RegionManCapProvider(World world) {
            this.manager = new RegionManagerImpl(world);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry entry : this.manager.idToRegion.entrySet()) {
                tag.func_74782_a((String)entry.getKey(), (NBTBase)((RegionImpl)entry.getValue()).serializeNBT());
            }
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            for (String s : nbt.func_150296_c()) {
                RegionImpl region = new RegionImpl(s, this.manager);
                region.deserializeNBT(nbt.func_74775_l(s));
                this.manager.idToRegion.put(s, region);
            }
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == REGION_MANAGER;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return TypeUtils.cast(capability == REGION_MANAGER ? this.manager : null);
        }
    }
}

