/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.world.region;

import com.google.common.collect.Sets;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import net.infstudio.infinitylib.api.utils.CapabilityUtils;
import net.infstudio.infinitylib.api.utils.NBTTagBuilder;
import net.infstudio.infinitylib.api.world.region.Region;
import net.infstudio.infinitylib.api.world.region.RegionEvent;
import net.infstudio.infinitylib.world.region.RegionInternal;
import net.infstudio.infinitylib.world.region.RegionManagerImpl;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;

public class RegionImpl
implements Region {
    private RegionManagerImpl manager;
    private final String id;
    private Area area;
    private int height = 50;
    private int depth = 30;
    private String name;
    private CapabilityDispatcher dispatcher;
    private Set<ChunkCoordIntPair> occupyChunk = Sets.newHashSet();

    public RegionImpl(String id, RegionManagerImpl manager) {
        this.id = id;
        this.manager = manager;
        this.area = new Area();
        this.dispatcher = CapabilityUtils.gatherCapabilities(new RegionEvent.AttachCapability(this));
    }

    @Override
    public boolean addRegion(int x1, int z1, int x2, int z2) {
        Rectangle rectangle = this.newRectangle(x1, z1, x2, z2);
        return false;
    }

    @Override
    public Rectangle newRectangle(int x1, int z1, int x2, int z2) {
        int x = Math.min(x1, x2);
        int z = Math.min(z1, z2);
        int xSize = Math.abs(x1 - x2);
        int zSize = Math.abs(z1 - z2);
        return new Rectangle(x, z, xSize, zSize);
    }

    @Override
    public boolean intersect(Rectangle2D rectangle2D) {
        if (!this.area.intersects(rectangle2D)) {
            return false;
        }
        PathIterator itr = rectangle2D.getPathIterator(null);
        double[] container = new double[6];
        while (!itr.isDone()) {
            int i = itr.currentSegment(container);
            if (i != 1 && i != 0 || !this.area.contains(container[0], container[1])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAll() {
        Rectangle bounds = this.area.getBounds();
        this.area.reset();
        this.occupyChunk.clear();
    }

    @Override
    public void removeRegion(int x1, int z1, int x2, int z2) {
        Rectangle re = this.newRectangle(x1, z1, x2, z2);
        this.area.subtract(new Area(re));
    }

    @Override
    public boolean include(int x, int z) {
        return this.area.contains(x, z);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PathIterator pathIterator() {
        return this.area.getPathIterator(null);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
    }

    public RegionImpl setName(String nameKey) {
        this.name = nameKey;
        return this;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.dispatcher != null && this.dispatcher.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.dispatcher == null ? null : this.dispatcher.getCapability(capability, facing));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagBuilder build = NBTTagBuilder.newBuilder().addString("name", this.name).addTag("area", (NBTBase)RegionInternal.toNBT(this.area)).addTag("capabilities", (NBTBase)this.dispatcher.serializeNBT());
        NBTTagList lst = new NBTTagList();
        for (ChunkCoordIntPair chunkCoordIntPair : this.occupyChunk) {
            lst.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{chunkCoordIntPair.field_77276_a, chunkCoordIntPair.field_77275_b}));
        }
        return build.addTag("chunks", (NBTBase)lst).build();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.area = RegionInternal.fromNBT(nbt.func_74775_l("area"));
        this.dispatcher.deserializeNBT(nbt.func_74775_l("capabilities"));
        NBTTagList chunks = nbt.func_150295_c("chunks", 11);
        for (int i = 0; i < chunks.func_74745_c(); ++i) {
            int[] arr = chunks.func_150306_c(i);
            this.occupyChunk.add(new ChunkCoordIntPair(arr[0], arr[1]));
        }
    }
}

