/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.world;

import com.google.common.collect.Maps;
import java.util.Map;
import net.infstudio.infinitylib.api.Instance;
import net.infstudio.infinitylib.api.registry.ModHandler;
import net.infstudio.infinitylib.api.registry.ModProxy;
import net.infstudio.infinitylib.api.utils.CapabilityUtils;
import net.infstudio.infinitylib.api.world.AttachWorldCapEvent;
import net.infstudio.infinitylib.api.world.ChunkData;
import net.infstudio.infinitylib.api.world.WorldPropertiesManager;
import net.infstudio.infinitylib.world.ChunkDataImpl;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@ModHandler
@ModProxy(side=Side.SERVER, genericType=WorldPropertiesManager.class)
public class WorldPropertiesManagers
implements WorldPropertiesManager {
    private Map<Integer, CapabilityDispatcher> dimensions = Maps.newHashMapWithExpectedSize((int)DimensionManager.getIDs().length);
    @Instance
    private static WorldPropertiesManagers instance = new WorldPropertiesManagers();

    public static WorldPropertiesManagers instance() {
        return instance;
    }

    private WorldPropertiesManagers() {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        CapabilityDispatcher dispatcher = CapabilityUtils.gatherCapabilities(new AttachWorldCapEvent(event.world));
        if (dispatcher != null) {
            int dimension = event.world.field_73011_w.func_177502_q();
            String name = "world_cap_" + dimension;
            CapLoader loader = (CapLoader)event.world.func_72943_a(CapLoader.class, name);
            loader.load(dispatcher);
            this.dimensions.put(dimension, dispatcher);
        }
    }

    @Override
    public ICapabilityProvider getCapabilityProvider(int dimension) {
        return (ICapabilityProvider)this.dimensions.get(dimension);
    }

    @Override
    public ICapabilityProvider getCapabilityProvider(World world) {
        return this.getCapabilityProvider(world.field_73011_w.func_177502_q());
    }

    @Override
    public ChunkData getChunkData(World world, BlockPos pos) {
        return ChunkDataImpl.getChunkData(world, pos);
    }

    @Override
    public ChunkData getChunkData(World world, ChunkCoordIntPair pos) {
        return ChunkDataImpl.getChunkData(world, pos);
    }

    @Override
    public ChunkData getChunkData(Chunk chunk) {
        return ChunkDataImpl.getChunkData(chunk);
    }

    private class CapLoader
    extends WorldSavedData {
        CapabilityDispatcher dispatcher;
        NBTTagCompound cache;

        public CapLoader(String name) {
            super(name);
        }

        void load(CapabilityDispatcher dispatcher) {
            this.dispatcher = dispatcher;
            dispatcher.deserializeNBT(this.cache);
            this.cache = null;
        }

        public void func_76184_a(NBTTagCompound nbt) {
        }

        public void func_76187_b(NBTTagCompound nbt) {
        }
    }
}

