/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.time;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.infstudio.infinitylib.api.network.ModNetwork;
import net.infstudio.infinitylib.api.registry.command.ModCommand;
import net.infstudio.infinitylib.api.utils.FileReference;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.infstudio.infinitylib.time.ColorModify;
import net.infstudio.infinitylib.time.Hook;
import net.infstudio.infinitylib.time.MessageTimeSync;
import net.infstudio.infinitylib.time.TimeController;
import net.infstudio.infinitylib.time.TimeEvent;
import net.infstudio.infinitylib.time.TimeLoadingPlugin;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.storage.SaveFormatComparator;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TimeMod
extends DummyModContainer {
    public static final String MODID = "Time";
    public static final String NAME = "TimeController";
    public static final String VERSION = "0.1";
    @SideOnly(value=Side.CLIENT)
    public static final ColorModify colorSpring = new ColorModify(){
        final int rS = 327680;
        final int gS = 10240;
        final int bS = 10;

        @Override
        public int processColor(int color) {
            return color + 327680 + 10240 + 10;
        }
    };
    @SideOnly(value=Side.CLIENT)
    public static final ColorModify colorSummer = new ColorModify(){

        @Override
        public int processColor(int color) {
            return color;
        }
    };
    @SideOnly(value=Side.CLIENT)
    public static final ColorModify colorFall = new ColorModify(){

        @Override
        public int processColor(int color) {
            return color;
        }
    };
    @SideOnly(value=Side.CLIENT)
    public static final ColorModify coloWinter = new ColorModify(){

        @Override
        public int processColor(int color) {
            return color;
        }
    };

    public TimeMod() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = MODID;
        meta.authorList.add("CI010");
        meta.version = VERSION;
        meta.name = NAME;
        meta.description = "A mod that makes some tweaks on Minecraft world time.";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public Object getMod() {
        return this;
    }

    @Subscribe
    public void construct(FMLConstructionEvent event) {
        NetworkRegistry.INSTANCE.register((ModContainer)this, ((Object)((Object)this)).getClass(), "", event.getASMHarvestedData());
    }

    @NetworkCheckHandler
    public boolean check(Map<String, String> modList, Side side) {
        if (side == Side.CLIENT) {
            return true;
        }
        DimensionManager.unregisterProviderType((int)0);
        DimensionManager.unregisterDimension((int)0);
        if (modList.containsKey(this.getModId()) || side == Side.CLIENT) {
            DimensionManager.registerProviderType((int)0, WorldProviderModified.class, (boolean)true);
        } else {
            DimensionManager.registerProviderType((int)0, WorldProviderSurface.class, (boolean)true);
        }
        DimensionManager.registerDimension((int)0, (int)0);
        return true;
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        DimensionManager.unregisterProviderType((int)0);
        DimensionManager.unregisterDimension((int)0);
        DimensionManager.registerProviderType((int)0, WorldProviderModified.class, (boolean)true);
        DimensionManager.registerDimension((int)0, (int)0);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_73011_w instanceof WorldProviderModified) {
            File saveDir = null;
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                try {
                    List saveList = (List)TypeUtils.cast(Minecraft.func_71410_x().func_71359_d().func_75799_b());
                    for (SaveFormatComparator token : saveList) {
                        if (!event.world.func_72912_H().func_76065_j().equals(token.func_75788_b())) continue;
                        saveDir = new File(FileReference.getSave(), token.func_75786_a());
                    }
                }
                catch (AnvilConverterException e) {
                    e.printStackTrace();
                }
            }
            if (saveDir == null) {
                saveDir = FileReference.getSave();
            }
            TimeController controller = new TimeController(event.world);
            try {
                NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)new File(saveDir, "time"));
                if (tag != null) {
                    controller.readFromNBT(tag);
                } else {
                    controller.fallbackSetting();
                }
            }
            catch (IOException e) {
                controller.fallbackSetting();
            }
            ((WorldProviderModified)event.world.field_73011_w).setController(controller);
            MinecraftForge.EVENT_BUS.register((Object)controller);
            MinecraftForge.EVENT_BUS.post((Event)new TimeEvent.Init(event.world, controller, controller.getCurrent()));
            if (!event.world.field_72995_K) {
                ModNetwork.instance().sendToDimension(new MessageTimeSync(controller), event.world.field_73011_w.func_177502_q());
            }
        }
    }

    @SubscribeEvent
    public void onGetGrassColor(BiomeEvent.GetGrassColor event) {
        event.newColor = Hook.provider.getController().modifyColor(event.originalColor);
    }

    @SubscribeEvent
    public void onGetFoColor(BiomeEvent.GetFoliageColor event) {
        event.newColor = Hook.provider.getController().modifyColor(event.originalColor);
    }

    @SubscribeEvent
    public void onTimeInit(TimeEvent.Init event) {
        if (event.world.field_72995_K) {
            Hook.init((WorldProviderModified)event.world.field_73011_w);
            event.getController().addColor("spring", colorSpring);
            event.getController().addColor("summer", colorSummer);
            event.getController().addColor("fall", colorFall);
            event.getController().addColor("winter", coloWinter);
        }
    }

    public File getSource() {
        return TimeLoadingPlugin.src;
    }

    @ModCommand
    public static class GetTime
    extends CommandBase {
        public String func_71517_b() {
            return "getTime";
        }

        public String func_71518_a(ICommandSender sender) {
            return "";
        }

        public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
            sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(sender.func_130014_f_().func_72820_D())));
            sender.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(sender.func_130014_f_().func_82737_E())));
        }
    }

    public static class WorldProviderModified
    extends WorldProviderSurface {
        private TimeController time;

        public float func_76563_a(long worldTime, float partialTick) {
            int current;
            float angle;
            long tickPerDay = 48000L;
            if (this.time != null) {
                tickPerDay = this.time.getTickPerDay();
            }
            if ((angle = ((float)(current = (int)(worldTime % tickPerDay)) + partialTick) / (float)tickPerDay - 0.25f) < 0.0f) {
                angle += 1.0f;
            }
            if (angle > 1.0f) {
                angle -= 1.0f;
            }
            float temp = angle;
            angle = 1.0f - (float)((Math.cos((double)angle * Math.PI) + 1.0) / 2.0);
            angle = temp + (angle - temp) / 3.0f;
            return angle;
        }

        public TimeController getController() {
            return this.time;
        }

        public void setController(TimeController controller) {
            this.time = controller;
        }
    }
}

