/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.sitting;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.infstudio.infinitylib.api.network.ModNetwork;
import net.infstudio.infinitylib.api.registry.ModHandler;
import net.infstudio.infinitylib.api.sitting.Sitable;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.infstudio.infinitylib.sitting.EntitySeat;
import net.infstudio.infinitylib.sitting.PlayerSitMessage;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@ModHandler
public class SitHandler {
    private static Map<Block, SittingMetaInfo> regMap = Maps.newConcurrentMap();

    public static void register(Sitable sitable) {
        Block block = sitable.sitableBlock();
        PropertyDirection dir = null;
        for (Object o : block.func_176223_P().func_177228_b().entrySet()) {
            Map.Entry entry = (Map.Entry)TypeUtils.cast(o);
            if (!(entry.getKey() instanceof PropertyDirection)) continue;
            dir = (PropertyDirection)entry.getKey();
        }
        regMap.put(block, new SittingMetaInfo(dir, sitable.getSituation()));
    }

    public static void sitOnBlock(World world, BlockPos pos, EntityPlayer player, Block block) {
        IBlockState state = world.func_180495_p(pos);
        SittingMetaInfo meta = regMap.get(block);
        if (meta.logic.shouldSit(player, pos)) {
            double x = pos.func_177958_n();
            double y = (float)pos.func_177956_o() + meta.logic.offsetVertical();
            double z = pos.func_177952_p();
            if (meta.dir != null) {
                EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)meta.dir);
                switch (face) {
                    case DOWN: {
                        break;
                    }
                    case UP: {
                        break;
                    }
                    case NORTH: {
                        z += (double)meta.logic.offsetHorizontal();
                        player.field_70177_z = 0.0f;
                        break;
                    }
                    case SOUTH: {
                        z -= (double)meta.logic.offsetHorizontal();
                        player.field_70177_z = 180.0f;
                        break;
                    }
                    case WEST: {
                        x -= (double)meta.logic.offsetHorizontal();
                        player.field_70177_z = 270.0f;
                        break;
                    }
                    case EAST: {
                        x += (double)meta.logic.offsetHorizontal();
                        player.field_70177_z = 90.0f;
                    }
                }
            }
            if (!SitHandler.existingEntity(world, x, y, z, player) && !world.field_72995_K) {
                EntitySeat nemb = new EntitySeat(world, x, y, z);
                world.func_72838_d((Entity)nemb);
                player.func_70078_a((Entity)nemb);
            }
        }
    }

    public static boolean existingEntity(World world, double x, double y, double z, EntityPlayer player) {
        List listEMB = world.func_72872_a(EntitySeat.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_72314_b(1.0, 1.0, 1.0));
        for (EntitySeat mount : listEMB) {
            if ((double)mount.blockPosX != x || (double)mount.blockPosY != y || (double)mount.blockPosZ != z) continue;
            if (mount.field_70153_n == null) {
                player.func_70078_a((Entity)mount);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onBlockActive(PlayerInteractEvent event) {
        Sitable.Situation logic;
        Block block;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && regMap.containsKey(block = event.entityPlayer.field_70170_p.func_180495_p(event.pos).func_177230_c()) && (logic = SitHandler.regMap.get((Object)block).logic).shouldSit(event.entityPlayer, event.pos)) {
            ModNetwork.instance().sendToServer(new PlayerSitMessage(logic.offsetVertical(), event.pos, block));
        }
    }

    @SubscribeEvent
    public void onMount(EntityMountEvent event) {
        if (event.entityMounting instanceof EntityPlayer && event.entityBeingMounted instanceof EntitySeat && event.isDismounting() && !event.entity.field_70170_p.field_72995_K) {
            event.entityBeingMounted.func_70106_y();
        }
    }

    private static class SittingMetaInfo {
        PropertyDirection dir;
        Sitable.Situation logic;

        public SittingMetaInfo(PropertyDirection dir, Sitable.Situation logic) {
            this.dir = dir;
            this.logic = logic;
        }
    }
}

