/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.recipe;

import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStacks
implements Comparable<ItemStacks> {
    protected String name;
    protected ItemStack[] materials;
    protected int size;
    protected int length;
    protected int height;
    protected boolean damageSensitive;
    protected boolean nbtSensitive;
    protected boolean raw;
    protected boolean oreDic;

    public ItemStacks(String name, int length, int height, ItemStack ... materials) {
        this.name = name;
        this.materials = materials;
        this.length = length;
        this.height = height;
        this.size = length * height;
        if (this.size != materials.length) {
            throw new IllegalArgumentException("Stack size error.");
        }
    }

    public ItemStacks(ItemStack ... materials) {
        this.materials = materials;
        this.size = materials.length;
        this.raw = true;
    }

    public ItemStacks damageSensitive() {
        this.damageSensitive = true;
        return this;
    }

    public ItemStacks nbtSensitive() {
        this.nbtSensitive = true;
        return this;
    }

    public int size() {
        return this.size;
    }

    @Override
    public int compareTo(ItemStacks o) {
        if (o == null) {
            return 1;
        }
        if (!o.raw && !this.raw) {
            return o.name.equals(this.name) ? 0 : 1;
        }
        if (o.size() != this.size()) {
            return o.size() - this.size();
        }
        if (o.length != this.length) {
            return o.length - this.length;
        }
        if (o.height != this.height) {
            return o.height - this.height;
        }
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = o.materials[i];
            ItemStack other = this.materials[i];
            if (stack == null && other == null) continue;
            if (other == null || stack == null) {
                return -1;
            }
            if ((this.nbtSensitive || o.nbtSensitive) && !stack.func_77978_p().equals((Object)other.func_77978_p())) {
                return -1;
            }
            int[] thisIds = OreDictionary.getOreIDs((ItemStack)stack);
            int[] otherIds = OreDictionary.getOreIDs((ItemStack)other);
            for (int j = 0; j < thisIds.length; ++j) {
                if (thisIds[j] == otherIds[j]) continue;
                return -1;
            }
            if (other.func_77973_b() == stack.func_77973_b() && (!this.damageSensitive && !o.damageSensitive || other.func_77952_i() == stack.func_77952_i())) continue;
            return -1;
        }
        return 0;
    }
}

