/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.inventory;

import com.google.common.base.Optional;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.infstudio.infinitylib.api.inventory.Inventory;
import net.infstudio.infinitylib.api.inventory.InventoryBuilder;
import net.infstudio.infinitylib.api.inventory.InventoryElement;
import net.infstudio.infinitylib.api.inventory.InventorySpace;
import net.infstudio.infinitylib.api.inventory.Layout;
import net.infstudio.infinitylib.common.Vector2i;

public class InventoryToJson {
    public static String inventoryToJson(final Inventory inv) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Layout.class, (Object)new JsonSerializer<Layout>(){

            public JsonElement serialize(Layout src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray array = new JsonArray();
                for (InventoryElement element : inv) {
                    JsonObject object = new JsonObject();
                    object.addProperty("id", (Number)element.id());
                    Optional<String> optional = element.name();
                    if (optional.isPresent()) {
                        object.addProperty("name", (String)optional.get());
                    }
                    object.addProperty("type", element instanceof InventorySpace ? "space" : "slot");
                    if (element instanceof InventorySpace) {
                        object.addProperty("xSize", (Number)((InventorySpace)element).xSize());
                        object.addProperty("ySize", (Number)((InventorySpace)element).ySize());
                    }
                    JsonArray pos = new JsonArray();
                    Vector2i srcPos = src.getPos(element.id());
                    pos.add((JsonElement)new JsonPrimitive((Number)srcPos.getX()));
                    pos.add((JsonElement)new JsonPrimitive((Number)srcPos.getY()));
                    object.add("pos", (JsonElement)pos);
                    array.add((JsonElement)object);
                }
                return array;
            }
        });
        return builder.create().toJson((Object)inv.getLayout());
    }

    public static void allocLayoutFromJson(final InventoryBuilder builder, String json) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Layout.class, (Object)new JsonDeserializer<Layout>(){

            public Layout deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonArray arr = json.getAsJsonArray();
                for (int i = 0; i < arr.size(); ++i) {
                    JsonObject obj = arr.get(i).getAsJsonObject();
                    int id = -1;
                    String name = null;
                    if (obj.has("id")) {
                        id = obj.get("id").getAsInt();
                    }
                    if (obj.has("name")) {
                        name = obj.get("name").getAsString();
                    }
                    if (!obj.has("pos")) {
                        throw new IllegalArgumentException();
                    }
                    JsonArray posArr = obj.get("pos").getAsJsonArray();
                    int x = posArr.get(0).getAsInt();
                    int y = posArr.get(1).getAsInt();
                    if (id == -1 && name == null) {
                        throw new IllegalArgumentException();
                    }
                    if (id == -1) {
                        boolean find = false;
                        for (int j = 0; j < builder.currentSize(); ++j) {
                            InventoryElement element = builder.getElement(j);
                            Optional<String> stringOptional = element.name();
                            if (!stringOptional.isPresent() || !name.equals(stringOptional.get())) continue;
                            find = true;
                            builder.allocPos(element, x, y);
                        }
                        if (find) continue;
                    }
                    InventoryElement element = builder.getElement(id);
                    builder.allocPos(element, x, y);
                    if (name == null) continue;
                    builder.allocName(element, name);
                }
                return null;
            }
        });
        gsonBuilder.create().fromJson(json, Layout.class);
    }
}

