/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.infstudio.infinitylib.api.Callback;
import net.infstudio.infinitylib.api.inventory.Inventory;
import net.infstudio.infinitylib.api.inventory.InventoryElement;
import net.infstudio.infinitylib.api.inventory.Layout;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class InvImpl
implements Inventory,
ISidedInventory {
    private ArrayList<ItemStack> stacks;
    private EnumMap<EnumFacing, int[]> sideMap;
    private ArrayList<InventoryElement> elements;
    private int size;
    private Layout layout;
    private IItemHandler wrap;
    private Callback.Container<ISidedInventory> container = new Callback.Container<ISidedInventory>(){
        private LinkedList<Callback<ISidedInventory>> spaces = Lists.newLinkedList();

        @Override
        public void add(Callback<ISidedInventory> callBack) {
            this.spaces.add(callBack);
        }

        @Override
        public void remove(Callback<ISidedInventory> callBack) {
            this.spaces.remove(callBack);
        }

        @Override
        public Iterator<Callback<ISidedInventory>> iterator() {
            return this.spaces.iterator();
        }
    };

    public InvImpl() {
        this.wrap = new InvWrapper((IInventory)this);
    }

    void build(EnumMap<EnumFacing, int[]> sideMap, int size, ArrayList<InventoryElement> elements, Layout layout) {
        this.sideMap = sideMap;
        this.size = size;
        this.elements = elements;
        this.stacks = Lists.newArrayListWithCapacity((int)this.size);
        this.layout = layout;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.sideMap != null ? this.sideMap.get(side) : new int[]{};
    }

    public int func_70302_i_() {
        return this.size;
    }

    public int getSlots() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return this.stacks.get(index);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int s = stack.field_77994_a;
        ItemStack r = this.wrap.insertItem(slot, stack, simulate);
        if (!simulate && s != r.field_77994_a) {
            this.func_70296_d();
        }
        return r;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate && amount != 0) {
            this.func_70296_d();
        }
        return this.wrap.extractItem(slot, amount, simulate);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.stacks.get(index) != null) {
            if (this.stacks.get((int)index).field_77994_a <= this.size) {
                ItemStack stack = this.stacks.get(index);
                this.stacks.set(index, null);
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = this.stacks.get(index).func_77979_a(this.size);
            if (this.stacks.get((int)index).field_77994_a == 0) {
                this.stacks.set(index, null);
            }
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.stacks.get(index) != null) {
            ItemStack itemstack = this.stacks.get(index);
            this.stacks.set(index, null);
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, stack);
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (Callback callback : this.getCallback()) {
            callback.onChange(this);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.elements.get(index).getRule().isItemValid(stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (this.sideMap.containsKey(direction)) {
            for (int i : this.sideMap.get(direction)) {
                if (index != i) continue;
                return this.elements.get(index).getRule().isItemValid(itemStackIn);
            }
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (this.sideMap.containsKey(direction)) {
            for (int i : this.sideMap.get(direction)) {
                if (index != i) continue;
                return this.elements.get(index).getRule().isItemValid(stack);
            }
        }
        return false;
    }

    public String func_70005_c_() {
        return "Inventory_Impl";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return new ChatComponentText(this.func_70005_c_());
    }

    @Override
    public Callback.Container<ISidedInventory> getCallback() {
        return this.container;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public Iterator<InventoryElement> iterator() {
        return this.elements.iterator();
    }
}

