/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.gui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.infstudio.infinitylib.api.Pipeline;
import net.infstudio.infinitylib.api.registry.ModProxy;
import net.infstudio.infinitylib.api.remote.gui.ComponentAPI;
import net.infstudio.infinitylib.api.remote.gui.ComponentRepository;
import net.infstudio.infinitylib.api.remote.gui.Properties;
import net.infstudio.infinitylib.api.remote.gui.components.GuiComponent;
import net.infstudio.infinitylib.api.remote.gui.node.DrawNode;
import net.infstudio.infinitylib.api.seril.IJsonSerializer;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;

@ModProxy(side=Side.SERVER, genericType=ComponentRepository.class)
public class ComponentRegistryCommon
implements ComponentRepository {
    private static Set<Class<?>> supportedType = Sets.newHashSet((Object[])new Class[]{Integer.TYPE, Float.TYPE, Short.TYPE, Long.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Float.class, Long.class, Character.class, Double.class, Short.class, String.class, Integer.class, Boolean.class, Enum.class});
    private BiMap<ResourceLocation, DrawNode> map = HashBiMap.create();
    private Map<ResourceLocation, Properties.Key> propMap = Maps.newHashMap();
    private Map<Class, IJsonSerializer> serializableMap = Maps.newHashMap();

    protected void register() {
        this.registerDrawNode(ComponentAPI.LOC_DRAW_TEXTURE, null);
        this.registerDrawNode(ComponentAPI.LOC_DRAW_BACKGROUND, null);
        this.registerDrawNode(ComponentAPI.LOC_DRAW_BORDER_TEXTS, null);
        this.registerDrawNode(ComponentAPI.LOC_DRAW_STRING, null);
        this.registerDrawNode(ComponentAPI.LOC_ANIM_FADE_IN, null);
        this.registerDrawNode(ComponentAPI.LOC_ANIM_FADE_IN, null);
        this.registerDrawNode(new ResourceLocation("draw:pre"), null);
        this.registerDrawNode(new ResourceLocation("draw:post"), null);
    }

    @Override
    public DrawNode fetchNode(ResourceLocation location) {
        return (DrawNode)this.map.get((Object)location);
    }

    @Override
    public <T> Properties.Key<T> fetchKey(DrawNode node, Class<T> type) {
        return this.fetchKey((ResourceLocation)this.map.inverse().get((Object)node), type);
    }

    @Override
    public <T> Properties.Key<T> fetchKey(ResourceLocation location, Class<T> type) {
        return (Properties.Key)TypeUtils.cast(this.propMap.get(new ResourceLocation(location.toString().concat(".").concat(type.getSimpleName().toLowerCase()))));
    }

    @Override
    public Properties newProperty() {
        return null;
    }

    @Override
    public Pipeline<DrawNode> newDrawPipe() {
        return null;
    }

    public void registerDrawNode(ResourceLocation location, DrawNode drawable) {
        if (this.map.containsKey((Object)location)) {
            throw new IllegalArgumentException("duplicate key");
        }
        if (this.getClass() == ComponentRegistryCommon.class) {
            this.map.put((Object)location, (Object)new ClientElement(location));
        } else {
            this.map.put((Object)location, (Object)drawable);
        }
    }

    public <T> void registerSerializer(IJsonSerializer<T> serializer, Class<T> type) {
        this.serializableMap.put(type, serializer);
    }

    class ClientElement
    implements DrawNode {
        ResourceLocation loc;

        public ClientElement(ResourceLocation name) {
            this.loc = name;
        }

        @Override
        public void draw(GuiComponent.Transform transform, Pipeline<DrawNode> pipeline, Properties properties) {
        }
    }
}

