/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.entity;

import com.google.common.collect.ImmutableList;
import net.infstudio.infinitylib.api.seril.ITagSerializable;
import net.infstudio.infinitylib.api.seril.ITagSerializer;
import net.infstudio.infinitylib.api.vars.VarSync;
import net.infstudio.infinitylib.api.vars.VarSyncBase;
import net.infstudio.infinitylib.api.vars.VarSyncFactory;
import net.infstudio.infinitylib.common.VarSyncPrimitive;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityVarFactory
implements VarSyncFactory {
    private ImmutableList.Builder<ITagSerializable> varCache = ImmutableList.builder();

    @Override
    public VarSync<Integer> newInteger(String name, int i) {
        VarSyncPrimitive<Integer> var = new VarSyncPrimitive<Integer>(name, i);
        this.varCache.add(var);
        return var;
    }

    @Override
    public VarSync<Float> newFloat(String name, float f) {
        VarSyncPrimitive<Float> var = new VarSyncPrimitive<Float>(name, Float.valueOf(f));
        this.varCache.add(var);
        return var;
    }

    @Override
    public VarSync<Short> newShort(String name, short l) {
        VarSyncPrimitive<Short> var = new VarSyncPrimitive<Short>(name, l);
        this.varCache.add(var);
        return var;
    }

    @Override
    public VarSync<Byte> newByte(String name, byte b) {
        VarSyncPrimitive<Byte> var = new VarSyncPrimitive<Byte>(name, b);
        this.varCache.add(var);
        return var;
    }

    @Override
    public VarSync<String> newString(String name, String s) {
        VarSyncPrimitive<String> var = new VarSyncPrimitive<String>(name, s);
        this.varCache.add(var);
        return var;
    }

    @Override
    public VarSync<Double> newDouble(String name, double d) {
        VarSyncPrimitive<Double> var = new VarSyncPrimitive<Double>(name, d);
        this.varCache.add(var);
        return var;
    }

    @Override
    public <T extends Enum<T>> VarSync<T> newEnum(String name, T e, Class<T> enumClass) {
        VarSyncBase var = new VarSyncBase<T>(){

            @Override
            public void readFromNBT(NBTTagCompound tag) {
                this.load(Enum.valueOf(((Enum)this.get()).getDeclaringClass(), tag.func_74779_i("enum-name")));
            }

            @Override
            public void writeToNBT(NBTTagCompound tag) {
                tag.func_74778_a("enum-name", ((Enum)this.get()).name());
            }
        };
        this.varCache.add((Object)var);
        return var;
    }

    @Override
    public <T> VarSync<T> newVar(T init, final ITagSerializer<T> serializer) {
        VarSyncBase base = new VarSyncBase<T>(){

            @Override
            public void readFromNBT(NBTTagCompound tag) {
                serializer.readFromNBT(tag, this.data);
            }

            @Override
            public void writeToNBT(NBTTagCompound tag) {
                serializer.writeToNBT(tag, this.data);
            }
        };
        base.set(init);
        this.varCache.add((Object)base);
        return base;
    }
}

