/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.entity;

import java.util.concurrent.Callable;
import net.infstudio.infinitylib.api.inventory.Inventory;
import net.infstudio.infinitylib.api.remote.capabilities.ISyncPortal;
import net.infstudio.infinitylib.entity.CapabilityDelegate;
import net.infstudio.infinitylib.entity.EntityVarFactory;
import net.infstudio.infinitylib.entity.TileEntityVarFactory;
import net.infstudio.infinitylib.inventory.InvImpl;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityInterfaceInject {
    private static ResourceLocation location = new ResourceLocation("helper", "delegate");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttachCapEntityStart(AttachCapabilitiesEvent.Entity event) {
        event.addCapability(location, (ICapabilityProvider)new CapabilityDelegate());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttachCapEntity(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof ISyncPortal) {
            ISyncPortal syncPortal = (ISyncPortal)event.getEntity();
            EntityVarFactory varFactory = new EntityVarFactory(event.getEntity());
            syncPortal.buildVars(varFactory);
            varFactory.getAllTracking();
        }
        for (ICapabilityProvider provider : event.getCapabilities().values()) {
            if (!(provider instanceof ISyncPortal)) continue;
            ISyncPortal syncPortal = (ISyncPortal)provider;
            EntityVarFactory varFactory = new EntityVarFactory(event.getEntity());
            syncPortal.buildVars(varFactory);
        }
    }

    @SubscribeEvent
    public void onAttachCapTileEntity(AttachCapabilitiesEvent.TileEntity event) {
        if (event.getTileEntity() instanceof ISyncPortal) {
            ISyncPortal syncPortal = (ISyncPortal)event.getTileEntity();
            TileEntityVarFactory factory = new TileEntityVarFactory();
            syncPortal.buildVars(factory);
        }
        for (ICapabilityProvider provider : event.getCapabilities().values()) {
            if (!(provider instanceof ISyncPortal)) continue;
            ISyncPortal syncPortal = (ISyncPortal)provider;
            TileEntityVarFactory factory = new TileEntityVarFactory();
            syncPortal.buildVars(factory);
        }
    }

    static {
        CapabilityManager.INSTANCE.register(Inventory.class, (Capability.IStorage)new Capability.IStorage<Inventory>(){

            public NBTBase writeNBT(Capability<Inventory> capability, Inventory instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<Inventory> capability, Inventory instance, EnumFacing side, NBTBase nbt) {
            }
        }, (Callable)new Callable<Inventory>(){

            @Override
            public Inventory call() throws Exception {
                return new InvImpl();
            }
        });
    }
}

