/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.entity;

import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.infstudio.infinitylib.api.vars.VarSync;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityDelegate
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=CapabilityDelegate.class)
    public static final Capability<CapabilityDelegate> DELEGATE = null;
    private VarSync[] tagSerializables;
    private Capability[] types;

    public CapabilityDelegate() {
    }

    public CapabilityDelegate(VarSync[] tagSerializables, Capability<?>[] type) {
        this.tagSerializables = tagSerializables;
        this.types = type;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        for (Capability type : this.types) {
            if (type != capability) continue;
            return true;
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != capability) continue;
            return TypeUtils.cast(this.tagSerializables[i]);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        for (VarSync serializable : this.tagSerializables) {
            serializable.writeToNBT(compound);
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (VarSync serializable : this.tagSerializables) {
            serializable.readFromNBT(nbt);
        }
    }
}

