/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common.registry.delegate;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.Instance;
import net.infstudio.infinitylib.api.LoadingDelegate;
import net.infstudio.infinitylib.api.registry.ASMRegistryDelegate;
import net.infstudio.infinitylib.api.registry.ModHandler;
import net.infstudio.infinitylib.common.DebugLogger;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

@LoadingDelegate
public class HandlerDelegate
extends ASMRegistryDelegate<ModHandler> {
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Object obj = null;
        AccessibleObject field = null;
        boolean setField = false;
        boolean weak = false;
        for (Field f : this.getAnnotatedClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(Instance.class)) continue;
            Instance anno = f.getAnnotation(Instance.class);
            weak = anno.weak();
            if (!Modifier.isStatic(f.getModifiers())) continue;
            field = f;
        }
        if (field != null) {
            if (!field.isAccessible()) {
                ((Field)field).setAccessible(true);
            }
            try {
                obj = ((Field)field).get(null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (obj == null && !weak) {
            try {
                Constructor<?> constructor = this.getAnnotatedClass().getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                obj = constructor.newInstance(new Object[0]);
                setField = true;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (field != null && setField) {
            try {
                if (!field.isAccessible()) {
                    ((Field)field).setAccessible(true);
                }
                ((Field)field).set(null, obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (obj == null) {
            HelperMod.LOG.fatal("Cannot create an instance of {}. It will not be registered as a handler.", new Object[]{this.getAnnotatedClass()});
            return;
        }
        ImmutableSet set = ImmutableSet.copyOf((Object[])((ModHandler)this.getAnnotation()).value());
        String info = "Register EventHandler: [";
        for (ModHandler.Type type : set) {
            info = info.concat(type.toString()).concat("|");
        }
        info = info.substring(0, info.length() - 1).concat("] <- [{}:{}]");
        DebugLogger.info(info, this.getModid(), this.getAnnotatedClass().getName());
        if (set.isEmpty()) {
            DebugLogger.warn("The handler class [{}] doesn't contain any method needed to be registered!", this.getAnnotatedClass().getName());
            return;
        }
        if (set.contains((Object)ModHandler.Type.Terrain)) {
            MinecraftForge.TERRAIN_GEN_BUS.register(obj);
        }
        if (set.contains((Object)ModHandler.Type.Forge) || set.contains((Object)ModHandler.Type.FML)) {
            MinecraftForge.EVENT_BUS.register(obj);
        }
        if (set.contains((Object)ModHandler.Type.OreGen)) {
            MinecraftForge.ORE_GEN_BUS.register(obj);
        }
    }
}

