/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common.registry;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.Instance;
import net.infstudio.infinitylib.api.LoadingDelegate;
import net.infstudio.infinitylib.api.registry.ASMRegistryDelegate;
import net.infstudio.infinitylib.api.registry.ModProxy;
import net.infstudio.infinitylib.api.utils.ASMDataUtil;
import net.infstudio.infinitylib.api.utils.PackageModIdMap;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.infstudio.infinitylib.common.DebugLogger;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.relauncher.Side;

public final class RegistryBufferManager {
    private static RegistryBufferManager instance;
    private Multimap<Class<? extends FMLStateEvent>, SubscriberInfo> subscriberInfoMap = HashMultimap.create();
    private PackageModIdMap rootMap = new PackageModIdMap();

    public static RegistryBufferManager instance() {
        if (instance == null) {
            instance = new RegistryBufferManager();
        }
        return instance;
    }

    private void loadProxy(ASMDataTable table) {
        HashMap proxyClasses = Maps.newHashMap();
        Set proxyClassData = table.getAll(ModProxy.class.getName());
        for (ASMDataTable.ASMData data : proxyClassData) {
            ModProxy modProxy = ASMDataUtil.getAnnotation(data, ModProxy.class);
            if (modProxy.side() != HelperMod.proxy.getSide() && modProxy.side() != Side.SERVER) continue;
            Class<?> clz = ASMDataUtil.getClass(data);
            Optional<?> grab = Instance.Utils.grab(clz);
            if (grab.isPresent()) {
                proxyClasses.put(new ClassKey(clz, modProxy.genericType() == Void.class ? clz.getSuperclass() : modProxy.genericType()), grab.get());
                continue;
            }
            proxyClasses.put(new ClassKey(clz, modProxy.genericType() == Void.class ? clz.getSuperclass() : modProxy.genericType()), clz);
        }
        Set injectClass = table.getAll(ModProxy.Inject.class.getName());
        for (ASMDataTable.ASMData data : injectClass) {
            Field field = ASMDataUtil.getField(data);
            if (field == null) {
                return;
            }
            if (!Modifier.isStatic(field.getModifiers()) || !field.isAccessible()) continue;
            Object o = proxyClasses.get(field.getType());
            if (o == null) {
                DebugLogger.fatal("Cannot find the proxy with type of {}", field.getType());
                return;
            }
            if (o instanceof Class) {
                Class clz = (Class)o;
                try {
                    o = clz.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(null, o);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public final void load(ASMDataTable table) {
        for (ASMDataTable.ASMData data : table.getAll(Mod.class.getName())) {
            this.rootMap.put(ASMDataUtil.getClass(data).getPackage().getName(), data.getAnnotationInfo().get("modid").toString());
        }
        this.loadProxy(table);
        for (ASMDataTable.ASMData data : table.getAll(LoadingDelegate.class.getName())) {
            Class<?> registryDelegateType = ASMDataUtil.getClass(data);
            boolean asmType = ASMRegistryDelegate.class.isAssignableFrom(registryDelegateType);
            Optional<?> optional = Instance.Utils.grab(registryDelegateType);
            if (!optional.isPresent()) {
                return;
            }
            Object delegate = optional.get();
            for (Method method : registryDelegateType.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Mod.EventHandler.class)) continue;
                if (method.getParameterTypes().length != 1) {
                    throw new UnsupportedOperationException("The method being subscribed need to have ONLY one parameter!");
                }
                Class<?> methodParam = method.getParameterTypes()[0];
                if (!FMLStateEvent.class.isAssignableFrom(methodParam)) {
                    throw new UnsupportedOperationException("The method's parameter must be a FMLStateEvent but not ".concat(methodParam.getName()));
                }
                if (methodParam == FMLServerStoppedEvent.class && methodParam == FMLServerStoppingEvent.class) {
                    throw new UnsupportedOperationException("Not support FMLServerStoppedEvent and FMLServerStoppingEvent");
                }
                Class state = TypeUtils.cast(methodParam);
                if (asmType) {
                    ASMRegistryDelegate asmDelegate = (ASMRegistryDelegate)delegate;
                    Class target = TypeUtils.getGenericTypeTo(asmDelegate);
                    ArrayList list = Lists.newArrayList((Iterable)table.getAll(target.getName()));
                    Collections.sort(list, new Comparator<ASMDataTable.ASMData>(){

                        @Override
                        public int compare(ASMDataTable.ASMData o1, ASMDataTable.ASMData o2) {
                            return o1.getClassName().compareTo(o2.getClassName());
                        }
                    });
                    for (ASMDataTable.ASMData meta : list) {
                        Package pkg = ASMDataUtil.getClass(meta).getPackage();
                        String modid = this.rootMap.getModid(pkg.getName());
                        if (modid == null) {
                            modid = "helper";
                            System.out.println("Anonymous for " + pkg.getName());
                        }
                        asmDelegate.addCache(modid, meta);
                    }
                }
                this.subscriberInfoMap.put(state, (Object)new SubscriberInfo(delegate, method));
            }
        }
    }

    public void invoke(FMLStateEvent state) {
        Class<?> realType = state.getClass();
        for (SubscriberInfo info : this.subscriberInfoMap.get(realType)) {
            try {
                if (info.obj instanceof ASMRegistryDelegate) {
                    ASMRegistryDelegate asmRegistryDelegate = (ASMRegistryDelegate)info.obj;
                    while (asmRegistryDelegate.hasNext()) {
                        asmRegistryDelegate.next();
                        info.method.invoke(info.obj, state);
                    }
                    continue;
                }
                info.method.invoke(info.obj, state);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                System.out.println(info);
                e.printStackTrace();
            }
        }
        if (state instanceof FMLLoadCompleteEvent) {
            this.rootMap = null;
            ASMDataUtil.clear();
            this.subscriberInfoMap.removeAll(FMLConstructionEvent.class);
            this.subscriberInfoMap.removeAll(FMLPreInitializationEvent.class);
            this.subscriberInfoMap.removeAll(FMLInitializationEvent.class);
            this.subscriberInfoMap.removeAll(FMLPostInitializationEvent.class);
            this.subscriberInfoMap.removeAll(FMLLoadCompleteEvent.class);
        }
    }

    private class ClassKey {
        Class<?> clz;
        Class<?> genericType;

        ClassKey(Class<?> clz, Class<?> superClass) {
            this.clz = clz;
            this.genericType = superClass;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.genericType == Object.class) {
                return this.clz == o;
            }
            return this.genericType == o;
        }

        public int hashCode() {
            if (this.genericType != Object.class) {
                return this.genericType.hashCode();
            }
            return this.clz.hashCode();
        }
    }

    class SubscriberInfo {
        Object obj;
        Method method;

        public SubscriberInfo(Object obj, Method method) {
            this.obj = obj;
            this.method = method;
        }

        public String toString() {
            return this.obj.getClass().getName().concat(" ").concat(this.method.getName());
        }
    }
}

