/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common.registry;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import net.infstudio.infinitylib.api.registry.components.ComponentStruct;
import net.infstudio.infinitylib.api.registry.components.Construct;
import net.infstudio.infinitylib.common.registry.RegBlock;
import net.infstudio.infinitylib.common.registry.RegItem;
import net.infstudio.infinitylib.common.registry.abstracts.RegComponentBase;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public class RegStructReflect<T>
extends RegComponentBase<T> {
    private String unlocalizedName;
    private List<String> itemMeta = Lists.newArrayList();
    private List<String> blockMeta = Lists.newArrayList();
    private List<RegItem> items = Lists.newArrayList();
    private List<RegBlock> blocks = Lists.newArrayList();

    public RegStructReflect(T wrap) {
        super(wrap);
        Class<?> clz = wrap.getClass();
        try {
            this.discover(wrap, clz);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void discover(Object o, Class<?> clz) throws IllegalAccessException {
        Field[] declaredFields;
        for (Field f : declaredFields = clz.getDeclaredFields()) {
            Object o1;
            if (f.isAnnotationPresent(Construct.Ignore.class)) continue;
            Class<?> type = f.getType();
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            if ((o1 = f.get(o)) == null) continue;
            if (Block.class.isAssignableFrom(type)) {
                this.blockMeta.add(f.getName());
                this.blocks.add(new RegBlock((Block)o1));
                continue;
            }
            if (!Item.class.isAssignableFrom(type)) continue;
            this.itemMeta.add(f.getName());
            this.items.add(new RegItem((Item)o1));
        }
        Class<?> superclass = clz.getSuperclass();
        if (superclass.isAnnotationPresent(ComponentStruct.class)) {
            this.discover(o, superclass);
        }
    }

    @Override
    public RegComponentBase<T> setUnlocalizedName(String name) {
        String shortName;
        int i;
        this.unlocalizedName = name;
        for (i = 0; i < this.itemMeta.size(); ++i) {
            shortName = name.concat(".").concat(this.itemMeta.get(i));
            this.items.get(i).setUnlocalizedName(shortName);
            this.itemMeta.set(i, shortName);
        }
        for (i = 0; i < this.blockMeta.size(); ++i) {
            shortName = name.concat(".").concat(this.blockMeta.get(i));
            this.blocks.get(i).setUnlocalizedName(shortName);
            this.blockMeta.set(i, shortName);
        }
        return this;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public RegComponentBase<T> setCreativeTab(CreativeTabs tab) {
        return null;
    }

    @Override
    public RegComponentBase<T> register(String name) {
        int i;
        for (i = 0; i < this.itemMeta.size(); ++i) {
            this.items.get(i).register(this.itemMeta.get(i));
        }
        for (i = 0; i < this.blockMeta.size(); ++i) {
            this.blocks.get(i).register(this.blockMeta.get(i));
        }
        return this;
    }

    @Override
    public RegComponentBase<T> registerOre(String name) {
        return null;
    }

    @Override
    public RegComponentBase<T> registerModel(String name) {
        int i;
        for (i = 0; i < this.itemMeta.size(); ++i) {
            this.items.get(i).registerModel(this.itemMeta.get(i));
        }
        for (i = 0; i < this.blockMeta.size(); ++i) {
            this.blocks.get(i).registerModel(this.blockMeta.get(i));
        }
        return this;
    }
}

