/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common.registry;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.registry.components.ArgumentHelper;
import net.infstudio.infinitylib.api.registry.components.ComponentStruct;
import net.infstudio.infinitylib.common.Maker;
import net.infstudio.infinitylib.common.registry.Namespace;
import net.infstudio.infinitylib.common.registry.NamespaceMakerSimple;
import net.infstudio.infinitylib.common.registry.abstracts.ReflectionAnnotatedMaker;
import net.infstudio.infinitylib.common.registry.annotation.field.OreDic;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class NamespaceMakerComplex
implements Maker<Class<?>, ImmutableSet<Namespace>> {
    private ReflectionAnnotatedMaker<Object, ImmutableSet<Namespace>> maker;
    private ReflectionAnnotatedMaker<Object, ImmutableSet<Namespace>> itemBlockMaker;
    private NamespaceMakerSimple simpleMaker = new NamespaceMakerSimple();

    public NamespaceMakerComplex(Map<Class<? extends Annotation>, ArgumentHelper> map) {
        this.itemBlockMaker = new ReflectionAnnotatedMaker<Object, ImmutableSet<Namespace>>(map){

            @Override
            protected ImmutableSet<Namespace> warp(Field f, Object target) {
                Namespace space = Namespace.newSpace(f.getName(), target);
                String ore = null;
                OreDic anno = f.getAnnotation(OreDic.class);
                if (anno != null) {
                    ore = anno.value();
                }
                space.setOreName(ore);
                return ImmutableSet.of((Object)space);
            }
        };
        this.maker = new ReflectionAnnotatedMaker<Object, ImmutableSet<Namespace>>(map){

            @Override
            protected ImmutableSet<Namespace> warp(Field f, Object target) {
                return NamespaceMakerComplex.this.simpleMaker.make(target);
            }
        };
    }

    @Override
    public ImmutableSet<Namespace> make(Class<?> container) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Field f : container.getFields()) {
            if (Modifier.isStatic(f.getModifiers())) {
                Class<?> c = f.getType();
                if (Item.class.isAssignableFrom(c) || Block.class.isAssignableFrom(c)) {
                    builder.addAll((Iterable)this.itemBlockMaker.make(f));
                }
                if (!f.isAnnotationPresent(ComponentStruct.class)) continue;
                builder.addAll((Iterable)this.maker.make(f));
                continue;
            }
            HelperMod.LOG.info("The field {} in container {} is not static so that it won'registerInit be constructed and registered", new Object[]{f.getName(), container.getName()});
        }
        return builder.build();
    }
}

