/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.infstudio.infinitylib.api.registry.ModHandler;
import net.infstudio.infinitylib.api.utils.Environment;
import net.infstudio.infinitylib.api.utils.FileReference;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.FileUtils;

@ModHandler
public class ModelReporter {
    private static ItemModelSimpleInfo standard = new ItemModelSimpleInfo(){
        {
            this.parent = "builtin/generated";
            this.thirdperson = new PersonView();
            this.thirdperson.rotation = new int[]{-90, 0, 0};
            this.thirdperson.translation = new float[]{0.0f, 1.0f, -3.0f};
            this.thirdperson.scale = new float[]{0.55f, 0.55f, 0.55f};
            this.firstperson = new PersonView();
            this.firstperson.rotation = new int[]{0, -135, 25};
            this.firstperson.translation = new float[]{0.0f, 4.0f, 2.0f};
            this.firstperson.scale = new float[]{1.7f, 1.7f, 1.7f};
        }
    };

    @SubscribeEvent
    public void onModelPost(ModelBakeEvent event) {
        if (!Environment.debug()) {
            return;
        }
        HashMap map = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        Set set = (Set)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.modelLoader, (String[])new String[]{"missingVariants"});
        for (Object missing : set) {
            ResourceLocation location = new ResourceLocation(missing.func_110624_b(), missing.func_110623_a());
            if (map.containsKey(location)) {
                ((ModelStates)map.get(location)).addVariant(missing.func_177518_c());
                continue;
            }
            ModelStates temp = new ModelStates((ModelResourceLocation)missing);
            map.put(location, temp);
        }
        Gson gson = this.buildGson();
        try {
            for (ModelStates state : list) {
                if (state.vars.size() == 1 && state.vars.get(0).equals("inventory")) {
                    this.writeItem(state, gson);
                    continue;
                }
                this.writeBlock(state, gson);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        standard = null;
    }

    private void writeItem(ModelStates state, Gson gson) throws IOException {
        FileReference refer = FileReference.getRefer(state.domain());
        File modelItem = new File(refer.dirModelItem, state.path().concat(".json"));
        if (standard != null) {
            FileUtils.write((File)new File(refer.dirModelItem, "standard.json"), (CharSequence)gson.toJson((Object)standard));
        }
        standard = null;
        ItemModelSimpleInfo info = new ItemModelSimpleInfo();
        info.parent = state.domain().concat(":item/standard");
        info.texture = state.domain().concat(":item/").concat(state.path());
        FileUtils.write((File)modelItem, (CharSequence)gson.toJson((Object)info));
    }

    private void writeBlock(ModelStates state, Gson gson) throws IOException {
        FileReference refer = FileReference.getRefer(state.domain());
        File stateFile = new File(refer.dirBlockState, state.path().concat(".json"));
        File modelItem = new File(refer.dirModelItem, state.path().concat(".json"));
        FileUtils.write((File)stateFile, (CharSequence)gson.toJson((Object)state).replace('`', '='));
        for (String s : state.varPath) {
            File modelFile = new File(refer.dirModelBlock, s.concat(".json"));
            BlockModelSimpleInfo info = new BlockModelSimpleInfo();
            info.texture = state.domain().concat(":").concat(s).concat("_").concat("texture");
            FileUtils.write((File)modelFile, (CharSequence)gson.toJson((Object)info));
        }
        ItemModelSimpleInfo info = new ItemModelSimpleInfo();
        info.parent = state.domain().concat(":").concat("block").concat("/").concat(state.path());
        info.thirdperson = new PersonView();
        info.thirdperson.rotation = new int[]{10, -45, 170};
        info.thirdperson.translation = new float[]{0.0f, 1.5f, -2.75f};
        info.thirdperson.scale = new float[]{0.375f, 0.375f, 0.375f};
        FileUtils.write((File)modelItem, (CharSequence)gson.toJson((Object)info));
    }

    private Gson buildGson() {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(ModelStates.class, (Object)new TypeAdapter<ModelStates>(){

            public void write(JsonWriter out, ModelStates value) throws IOException {
                out.setIndent("  ");
                out.beginObject();
                out.name("variants").beginObject();
                for (int i = 0; i < value.vars.size(); ++i) {
                    String var = value.vars.get(i);
                    String varPth = value.varPath.get(i);
                    var = var.replace('=', '`');
                    out.name(var).beginObject();
                    out.name("model").value(value.domain().concat(":").concat(varPth)).endObject();
                }
                out.endObject().endObject();
            }

            public ModelStates read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(BlockModelSimpleInfo.class, (Object)new TypeAdapter<BlockModelSimpleInfo>(){

            public void write(JsonWriter out, BlockModelSimpleInfo value) throws IOException {
                out.setIndent("  ");
                out.beginObject();
                out.name("parent").value(value.parent);
                out.name("textures").beginObject();
                out.name("all").value(value.texture);
                out.endObject().endObject();
            }

            public BlockModelSimpleInfo read(JsonReader in) throws IOException {
                return null;
            }
        }).registerTypeAdapter(ItemModelSimpleInfo.class, (Object)new TypeAdapter<ItemModelSimpleInfo>(){

            public void write(JsonWriter out, ItemModelSimpleInfo value) throws IOException {
                out.setIndent("  ");
                out.beginObject();
                if (value.parent != null) {
                    out.name("parent").value(value.parent);
                }
                if (value.thirdperson != null || value.firstperson != null) {
                    out.name("display").beginObject();
                    if (value.thirdperson != null) {
                        this.write("thirdperson", out, value.thirdperson);
                    }
                    if (value.firstperson != null) {
                        this.write("firstperson", out, value.firstperson);
                    }
                    out.endObject();
                }
                if (value.texture != null) {
                    out.name("texture").beginObject();
                    out.name("layer0").value(value.texture);
                    out.endObject();
                }
                out.endObject();
            }

            private void write(String name, JsonWriter out, PersonView view) throws IOException {
                out.setIndent("  ");
                out.name(name).beginObject();
                out.name("rotation").beginArray();
                for (int i : view.rotation) {
                    out.value((long)i);
                }
                out.endArray();
                out.name("translation").beginArray();
                for (float i : view.translation) {
                    out.value((double)i);
                }
                out.endArray();
                out.name("scale").beginArray();
                for (float v : view.scale) {
                    out.value((double)v);
                }
                out.endArray().endObject();
            }

            public ItemModelSimpleInfo read(JsonReader in) throws IOException {
                return null;
            }
        });
        return builder.create();
    }

    private static class ModelStates {
        private ResourceLocation location;
        List<String> vars;
        List<String> varPath;

        public ModelStates(ModelResourceLocation resourceLocation) {
            this.location = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a());
            this.vars = Lists.newArrayList();
            this.varPath = Lists.newArrayList();
            this.addVariant(resourceLocation.func_177518_c());
        }

        public ModelStates(String domain, String path) {
            this.vars = Lists.newArrayList();
            this.varPath = Lists.newArrayList();
        }

        public ModelStates addVariant(String var) {
            String path = this.location.func_110623_a();
            this.vars.add(var);
            int idx = var.indexOf("=");
            if (idx != -1) {
                this.varPath.add(path.concat("_").concat(var.substring(var.indexOf("=") + 1)));
            } else {
                this.varPath.add(path);
            }
            return this;
        }

        public String domain() {
            return this.location.func_110624_b();
        }

        public String path() {
            return this.location.func_110623_a();
        }

        public String toString() {
            return this.location.toString();
        }
    }

    private static class BlockModelSimpleInfo {
        String parent = "block/cube_all";
        String texture;

        private BlockModelSimpleInfo() {
        }
    }

    private static class PersonView {
        int[] rotation;
        float[] scale;
        float[] translation;

        private PersonView() {
        }
    }

    private static class ItemModelSimpleInfo {
        String parent;
        String texture;
        PersonView thirdperson;
        PersonView firstperson;

        private ItemModelSimpleInfo() {
        }
    }
}

