/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common;

public class RegionalCache<Position> {
    private float[][] cache;
    private int radius;
    private int diameter;
    private OffsetMapping<Position> mapping;
    private Position center;
    private ValueDelegate<Position> delegate;

    public RegionalCache(int radius, OffsetMapping<Position> mapping, ValueDelegate<Position> delegate) {
        this.diameter = radius * 2 + 1;
        this.cache = new float[this.diameter][this.diameter];
        this.mapping = mapping;
        this.delegate = delegate;
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public float getCenter() {
        return this.cache[this.radius][this.radius];
    }

    public float[][] getCache() {
        float[][] temp = new float[this.diameter][this.diameter];
        System.arraycopy(this.cache, 0, temp, 0, this.diameter);
        return temp;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public void moveTo(Position pos) {
        if (this.center == null) {
            this.refresh(pos);
            return;
        }
        int xOffset = this.mapping.getXOffset(this.center, pos);
        int zOffset = this.mapping.getZOffset(this.center, pos);
        if (xOffset == 0 && zOffset == 0) {
            return;
        }
        this.center = pos;
        this.move(xOffset, zOffset);
    }

    private void move(int xOffset, int zOffset) {
        if (xOffset > this.diameter || zOffset > this.diameter) {
            this.refresh(this.center);
        } else {
            int x;
            float[][] temp = new float[this.diameter][this.diameter];
            int range = this.diameter + xOffset;
            if (xOffset < 0) {
                for (x = 0; x < range; ++x) {
                    if (zOffset >= 0) {
                        System.arraycopy(this.cache[x], 0, temp[x - xOffset], zOffset, this.diameter - zOffset);
                        continue;
                    }
                    System.arraycopy(this.cache[x], -zOffset, temp[x - xOffset], 0, this.diameter + zOffset);
                }
            } else if (xOffset >= 0) {
                for (x = xOffset; x < this.diameter; ++x) {
                    if (zOffset >= 0) {
                        System.arraycopy(this.cache[x], 0, temp[x - xOffset], zOffset, this.diameter - zOffset);
                        continue;
                    }
                    System.arraycopy(this.cache[x], -zOffset, temp[x - xOffset], 0, this.diameter + zOffset);
                }
            }
            for (x = 0; x < this.diameter; ++x) {
                for (int z = 0; z < this.diameter; ++z) {
                    float v = temp[x][z];
                    if (v != 0.0f) continue;
                    temp[x][z] = this.delegate.calculate(this.mapping.getPosFromOffset(this.center, x - this.radius, z - this.radius));
                }
            }
            this.cache = temp;
        }
    }

    public float getMean() {
        float sum = 0.0f;
        for (int x = 0; x < this.cache.length; ++x) {
            for (int z = 0; z < this.cache[x].length; ++z) {
                sum += this.cache[x][z];
            }
        }
        return sum / (float)(this.diameter * this.diameter);
    }

    public void refresh(Position center) {
        this.center = center;
        for (int x = 0; x < this.diameter; ++x) {
            for (int z = 0; z < this.diameter; ++z) {
                this.cache[x][z] = this.delegate.calculate(this.mapping.getPosFromOffset(this.center, x - this.radius, z - this.radius));
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int x = 0; x < this.diameter; ++x) {
            for (int y = 0; y < this.diameter; ++y) {
                builder.append(this.cache[x][y]).append(" ");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static interface OffsetMapping<T> {
        public int getXOffset(T var1, T var2);

        public int getZOffset(T var1, T var2);

        public T getPosFromOffset(T var1, int var2, int var3);
    }

    public static interface ValueDelegate<T> {
        public float calculate(T var1);
    }
}

