/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class PlayerModify {
    public static void modifyMaxHealth(EntityPlayer player, double factor, Type type) {
        PlayerModify.modifyShareAttr(SharedMonsterAttributes.field_111267_a, "mod_health", player, factor, type);
    }

    public static double getMaxHealth(EntityPlayer player) {
        return player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
    }

    public static void modifyAttack(EntityPlayer player, double factor, Type type) {
        PlayerModify.modifyShareAttr(SharedMonsterAttributes.field_111264_e, "mod_attack", player, factor, type);
    }

    public static double getAttack(EntityPlayer player) {
        return player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    public static void modifyMoveSpeed(EntityPlayer player, double factor, Type type) {
        PlayerModify.modifyShareAttr(SharedMonsterAttributes.field_111263_d, "mod_speed", player, factor, type);
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        player.field_71075_bZ.func_75091_a(nbtTagCompound);
        switch (type) {
            case set: {
                nbtTagCompound.func_74776_a("walkSpeed", (float)factor);
                break;
            }
            case add: {
                nbtTagCompound.func_74776_a("walkSpeed", (float)(factor + (double)nbtTagCompound.func_74760_g("walkSpeed")));
                break;
            }
            case multiply: {
                nbtTagCompound.func_74776_a("walkSpeed", (float)(factor * (double)nbtTagCompound.func_74760_g("walkSpeed")));
                break;
            }
            case scaleUp: {
                nbtTagCompound.func_74776_a("walkSpeed", (float)((factor + 1.0) * (double)nbtTagCompound.func_74760_g("walkSpeed")));
            }
        }
        player.field_71075_bZ.func_75095_b(nbtTagCompound);
    }

    public static void modifyJumpSpeed(EntityPlayer player, double factor, Type type) {
        switch (type) {
            case set: {
                ReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)factor, (String[])new String[]{"speedInAir"});
                break;
            }
            case add: {
                ReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)((double)((Float)ReflectionHelper.getPrivateValue(EntityPlayer.class, (Object)player, (String[])new String[]{"speedInAir"})).floatValue() + factor), (String[])new String[]{"speedInAir"});
                break;
            }
            case multiply: {
                ReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)((double)((Float)ReflectionHelper.getPrivateValue(EntityPlayer.class, (Object)player, (String[])new String[]{"speedInAir"})).floatValue() * factor), (String[])new String[]{"speedInAir"});
                break;
            }
            case scaleUp: {
                ReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)((double)((Float)ReflectionHelper.getPrivateValue(EntityPlayer.class, (Object)player, (String[])new String[]{"speedInAir"})).floatValue() * (1.0 + factor)), (String[])new String[]{"speedInAir"});
            }
        }
    }

    private static void modifyShareAttr(IAttribute attribute, String id, EntityPlayer player, double factor, Type type) {
        IAttributeInstance attr = player.func_110148_a(attribute);
        AttributeModifier mod = type == Type.set ? new AttributeModifier(id, attr.func_111126_e() - factor, Type.add.operation) : new AttributeModifier(id, factor, type.operation);
        attr.func_111121_a(mod);
    }

    public static enum Type {
        set(-1),
        add(0),
        multiply(1),
        scaleUp(2);

        int operation;

        private Type(int operation) {
            this.operation = operation;
        }
    }
}

