/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Pattern3D {
    protected List<Vector3D> sub;

    public boolean connected() {
        return this.connected(this.sub, Lists.newArrayList(), this.sub.get(0), 1, 1);
    }

    private boolean connected(List<Vector3D> points, List<Vector3D> done, Vector3D current, int direction, int original) {
        int nextDirection;
        if (!done.contains(current)) {
            done.add(current);
        }
        Vector3D next = null;
        switch (direction) {
            case 1: {
                next = current.offset(0, 0, 1);
                break;
            }
            case 2: {
                next = current.offset(1, 0, 0);
                break;
            }
            case 3: {
                next = current.offset(0, 0, -1);
                break;
            }
            case 4: {
                next = current.offset(-1, 0, 0);
                break;
            }
            case 5: {
                next = current.offset(0, 1, 0);
                break;
            }
            case 6: {
                next = current.offset(0, -1, 0);
            }
        }
        if (points.contains(next) && !done.contains(next)) {
            this.connected(points, done, next, direction, direction);
        }
        if ((nextDirection = (nextDirection = (direction + 1) % 6) == 0 ? 6 : nextDirection) == original) {
            return true;
        }
        this.connected(points, done, current, nextDirection, original);
        return done.size() == points.size();
    }

    public List<Vector3D> buildConnection(Vector3D start, Predicate<Vector3D> predicate) {
        ArrayList lst = Lists.newArrayListWithCapacity((int)1000000);
        this.buildConnection(lst, start, predicate, 1, 1);
        return lst;
    }

    private void buildConnection(List<Vector3D> lst, Vector3D current, Predicate<Vector3D> predicate, int direction, int original) {
        int nextDirection;
        if (lst.size() > 1000000) {
            return;
        }
        if (!predicate.apply((Object)current)) {
            return;
        }
        if (!lst.contains(current)) {
            lst.add(current);
        }
        Vector3D next = null;
        switch (direction) {
            case 1: {
                next = current.offset(0, 0, 1);
                break;
            }
            case 2: {
                next = current.offset(1, 0, 0);
                break;
            }
            case 3: {
                next = current.offset(0, 0, -1);
                break;
            }
            case 4: {
                next = current.offset(-1, 0, 0);
                break;
            }
            case 5: {
                next = current.offset(0, 1, 0);
                break;
            }
            case 6: {
                next = current.offset(0, -1, 0);
            }
        }
        if (!lst.contains(next)) {
            this.buildConnection(lst, next, predicate, direction, direction);
        }
        if ((nextDirection = (nextDirection = (direction + 1) % 6) == 0 ? 6 : nextDirection) == original) {
            return;
        }
        this.buildConnection(lst, current, predicate, nextDirection, original);
    }

    public Pattern3D(List<Vector3D> pos) {
        this.sub = pos;
        Collections.sort(this.sub);
        if (!this.connected()) {
            throw new IllegalArgumentException("The pattern is not continued!");
        }
    }

    public List<Vector3D> transferTo(Vector3D origin) {
        ArrayList result = Lists.newArrayList();
        for (Vector3D pos : this.sub) {
            result.add(pos.offset(origin.getX(), origin.getY(), origin.getZ()));
        }
        return result;
    }

    public static interface Vector3D
    extends Comparable<Vector3D> {
        public int getX();

        public int getY();

        public int getZ();

        public Vector3D offset(int var1, int var2, int var3);
    }
}

