/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.client.render;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.infstudio.infinitylib.api.registry.ModHandler;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ModHandler
@SideOnly(value=Side.CLIENT)
public class ClientRenderer {
    private HashSet<Work> works = Sets.newLinkedHashSet();
    private static final ClientRenderer instance = new ClientRenderer();

    public static ClientRenderer instance() {
        return instance;
    }

    private ClientRenderer() {
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        for (Work work : this.works) {
            work.render(event.context, event.partialTicks);
        }
    }

    public void remove(Work work) {
        this.works.remove(work);
    }

    public void add(Work work) {
        this.works.add(work);
    }

    static interface Work {
        public void render(RenderGlobal var1, float var2);
    }
}

