/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.client.loading;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ImageMerger {
    private List<BufferedImage> images = Lists.newLinkedList();
    private static int standardSize = 256;
    static Comparator<BufferedImage> comparator = new Comparator<BufferedImage>(){

        @Override
        public int compare(BufferedImage o1, BufferedImage o2) {
            return o1.getHeight() + o1.getWidth() - o2.getHeight() - o2.getWidth();
        }
    };

    public void add(BufferedImage image) {
        this.images.add(image);
    }

    private void build() {
        Collections.sort(this.images, new Comparator<BufferedImage>(){

            @Override
            public int compare(BufferedImage o1, BufferedImage o2) {
                return o1.getHeight() + o1.getWidth() - o2.getHeight() - o2.getWidth();
            }
        });
        BufferedImage newImg = new BufferedImage(256, 256, 2);
    }

    private void handle(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
    }

    private class TreeNode {
        BufferedImage image;
        TreeNode left;
        TreeNode right;

        public TreeNode(BufferedImage image) {
            this.image = image;
        }

        void put(BufferedImage image) {
            int compare = comparator.compare(this.image, image);
            if (compare < 0) {
                if (this.left != null) {
                    this.left.put(image);
                } else {
                    this.left = new TreeNode(image);
                }
            } else if (this.right != null) {
                this.right.put(image);
            } else {
                this.right = new TreeNode(image);
            }
        }
    }

    private class Tree {
        TreeNode root;

        private Tree() {
        }

        public void put(BufferedImage image) {
            if (this.root != null) {
                this.root.put(image);
            } else {
                this.root = new TreeNode(image);
            }
        }
    }
}

