/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.vars;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import net.infstudio.infinitylib.api.Callback;
import net.infstudio.infinitylib.api.vars.VarBase;
import net.infstudio.infinitylib.api.vars.VarNotify;

public abstract class VarNotifyBase<T>
extends VarBase<T>
implements VarNotify<T> {
    protected Set<Callback<VarNotify<T>>> listeners;

    protected void load(T data) {
        super.set(data);
    }

    @Override
    public void set(T data) {
        super.set(data);
        if (!data.equals(this.get()) && this.listeners != null) {
            for (Callback<VarNotify<VarNotifyBase>> callback : this.listeners) {
                callback.onChange(this);
            }
        }
    }

    @Override
    public void add(Callback<VarNotify<T>> callBack) {
        if (this.listeners == null) {
            this.listeners = Sets.newHashSet();
        }
        this.listeners.add(callBack);
    }

    @Override
    public void remove(Callback<VarNotify<T>> callBack) {
        if (this.listeners != null) {
            this.listeners.remove(callBack);
        }
    }

    @Override
    public Iterator<Callback<VarNotify<T>>> iterator() {
        return this.listeners.iterator();
    }
}

