/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.utils;

import com.google.common.collect.Lists;
import java.util.List;
import net.infstudio.infinitylib.common.CompiledLayout;
import org.lwjgl.util.vector.Vector2f;

public class GridLayoutBuilder {
    private int offset;
    private int numberOfElements;
    private List<Vector2f> lst = Lists.newArrayList();
    private Vector2f iconSize;
    private Vector2f containerSize;
    private Vector2f realCompSize;
    private boolean changed;
    private static String name = "Grid";

    public GridLayoutBuilder(Vector2f containerSize, Vector2f iconSize, int leastOffset, int numberOfElements) {
        this.setContainerSize(containerSize).setIconSize(iconSize).setOffset(leastOffset).setNumberOfElements(numberOfElements);
        this.make();
    }

    public GridLayoutBuilder setOffset(int offset) {
        this.offset = offset;
        this.changed = true;
        return this;
    }

    public GridLayoutBuilder setNumberOfElements(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.changed = true;
        return this;
    }

    public GridLayoutBuilder setIconSize(Vector2f iconSize) {
        this.iconSize = iconSize;
        this.changed = true;
        return this;
    }

    public GridLayoutBuilder setContainerSize(Vector2f containerSize) {
        this.containerSize = containerSize;
        this.changed = true;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GridLayoutBuilder) {
            GridLayoutBuilder o = (GridLayoutBuilder)obj;
            return o.offset == this.offset && o.iconSize.equals((Object)this.iconSize) && o.numberOfElements == this.numberOfElements && o.containerSize.equals((Object)this.containerSize);
        }
        return super.equals(obj);
    }

    private void make() {
        int i;
        this.changed = false;
        this.lst.clear();
        this.realCompSize = new Vector2f(this.iconSize.x + (float)this.offset, this.iconSize.y + (float)this.offset);
        int line = 1;
        int countInOneLine = this.numberOfElements / line;
        int perLength = (int)(this.containerSize.x / (float)countInOneLine);
        while ((float)perLength < this.iconSize.x + (float)this.offset) {
            countInOneLine = this.numberOfElements / ++line;
            perLength = (int)(this.containerSize.x / (float)countInOneLine);
        }
        int remainder = this.numberOfElements % line;
        float leftX = this.calLeftX(countInOneLine);
        for (i = 1; i <= line; ++i) {
            for (int j = 1; j <= countInOneLine; ++j) {
                this.lst.add(new Vector2f(leftX + (float)j * this.realCompSize.x, (float)this.offset + (float)i * this.realCompSize.y));
            }
        }
        leftX = this.calLeftX(remainder);
        for (i = 1; i <= remainder; ++i) {
            this.lst.add(new Vector2f(leftX + (float)i * this.realCompSize.x, (float)this.offset + (float)(line + 1) * this.realCompSize.y));
        }
    }

    public CompiledLayout build() {
        if (this.changed) {
            this.make();
        }
        return new CompiledLayout(){
            private Vector2f[] pos;
            {
                this.pos = new Vector2f[GridLayoutBuilder.this.lst.size()];
                this.pos = GridLayoutBuilder.this.lst.toArray(this.pos);
            }

            @Override
            public Vector2f getPos(int i) {
                return (Vector2f)GridLayoutBuilder.this.lst.get(i);
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    private float calLeftX(int numInOneLine) {
        float center = this.containerSize.x / 2.0f;
        if (numInOneLine % 2 == 1) {
            return center - this.iconSize.x / 2.0f - (float)(numInOneLine / 2) * this.realCompSize.x;
        }
        return center - (float)(this.offset / 2) - this.iconSize.x - (float)(numInOneLine / 2 - 1) * this.realCompSize.x;
    }
}

