/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.utils;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FileReference {
    public static final File mc = (File)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"mcDataDir"});
    private static Map<String, FileReference> refers = Maps.newHashMap();
    protected static File assets = FileReference.getDir(mc, "debug-reports");
    private static File logDir;
    private static File saveDir;
    public final File modFile;
    public final File dirBlockState;
    public final File dirModelBlock;
    public final File dirModelItem;
    public final File dirTextureBlock;
    public final File dirTextureItem;
    public final File dirLang;

    public static File getLog() {
        if (logDir == null) {
            logDir = new File(mc, "logs");
        }
        return logDir;
    }

    public static File getSave() {
        while (saveDir == null) {
            saveDir = DimensionManager.getCurrentSaveRootDirectory();
        }
        return saveDir;
    }

    public static void registerFile(String modid) {
        refers.put(modid, new FileReference(modid));
    }

    private FileReference(String id) {
        this.modFile = FileReference.getDir(assets, id);
        this.dirBlockState = FileReference.getDir(this.modFile, "blockstates");
        File dirModel = FileReference.getDir(this.modFile, "models");
        this.dirModelBlock = FileReference.getDir(dirModel, "block");
        this.dirModelItem = FileReference.getDir(dirModel, "item");
        this.dirLang = FileReference.getDir(this.modFile, "lang");
        File dirTexutre = FileReference.getDir(this.modFile, "textures");
        this.dirTextureBlock = FileReference.getDir(dirTexutre, "blocks");
        this.dirTextureItem = FileReference.getDir(dirTexutre, "items");
    }

    public static FileReference getRefer(String modid) {
        return refers.get(modid);
    }

    static void close() {
        refers = null;
    }

    public static File getDir(File parent, String name) {
        File f = new File(parent, name);
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public static File getDir(File parent, String ... path) {
        File f = parent;
        for (String s : path) {
            f = FileReference.getDir(f, s);
        }
        return f;
    }
}

